(()=>{var __webpack_modules__=({"./js/FilterGroup.js":
/*!***************************!*\
  !*** ./js/FilterGroup.js ***!
  \***************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ FilterGroup)\n/* harmony export */ });\n/* harmony import */ var modules_AdditionalFilters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! modules/AdditionalFilters */ \"./js/modules/AdditionalFilters.js\");\n/* harmony import */ var modules_CustomProvider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! modules/CustomProvider */ \"./js/modules/CustomProvider.js\");\n/* harmony import */ var modules_Indexer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! modules/Indexer */ \"./js/modules/Indexer.js\");\n/* harmony import */ var modules_TabIndex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! modules/TabIndex */ \"./js/modules/TabIndex.js\");\n/* harmony import */ var modules_ProviderPreloader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! modules/ProviderPreloader */ \"./js/modules/ProviderPreloader.js\");\n/* harmony import */ var modules_PredefinedData__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! modules/PredefinedData */ \"./js/modules/PredefinedData.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_request__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! includes/request */ \"./js/includes/request.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\n\n\n\n\nvar FilterGroup = /*#__PURE__*/function () {\n  function FilterGroup(provider, queryId) {\n    var _this = this;\n    var filters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];\n    _classCallCheck(this, FilterGroup);\n    _defineProperty(this, \"urlPrefix\", 'jsf');\n    _defineProperty(this, \"activeItemsExceptions\", ['sorting', 'pagination']);\n    this.provider = provider;\n    this.queryId = queryId;\n    this.filters = [];\n    this.providerSelector = this.getProviderSelector();\n    this.$provider = this.getProvider();\n    this.currentQuery = Object.assign({}, this.urlParams);\n    this.isAjaxLoading = false;\n\n    // URL data\n    this.urlType = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'misc', 'url_type') || 'plain';\n    this.baseUrl = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'baseurl');\n    this.baseUrlParams = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getThirdPartyUrlParams)();\n\n    // modules\n    this.additionalFilters = new modules_AdditionalFilters__WEBPACK_IMPORTED_MODULE_0__[\"default\"](this);\n    this.customProvider = new modules_CustomProvider__WEBPACK_IMPORTED_MODULE_1__[\"default\"](this);\n    this.providerPreloader = new modules_ProviderPreloader__WEBPACK_IMPORTED_MODULE_4__[\"default\"](this);\n    this.predefinedData = new modules_PredefinedData__WEBPACK_IMPORTED_MODULE_5__[\"default\"](this);\n\n    // initialization incoming filters\n    filters.forEach(function (filter) {\n      _this.addFilter(filter);\n    });\n    this.debounceProcessFilters = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.debounce)(this.processFilters, 100);\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('fiter/change', function (filter) {\n      if (!_this.isCurrentProvider(filter)) return;\n      _this.updateSameFilters(filter);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('fiter/syncSameFilters', function (filter) {\n      if (!_this.isCurrentProvider(filter)) return;\n      _this.syncSameFilters(filter);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('fiter/apply', function (filter) {\n      if (!_this.isCurrentProvider(filter)) return;\n      _this.applyFilterHandler(filter.applyType);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('fiters/apply', function (applyFilter) {\n      if (!_this.isCurrentProvider(applyFilter)) return;\n      _this.applyFiltersHandler(applyFilter.applyType, applyFilter.redirect && applyFilter.redirectPath ? applyFilter.redirectPath : false, applyFilter.redirectInNewWindow);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('fiters/remove', function (removeFilter) {\n      if (!_this.isCurrentProvider(removeFilter)) return;\n      _this.removeFiltersHandler(removeFilter.applyType);\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('pagination/change', function (paginationFilter) {\n      if (!_this.isCurrentProvider(paginationFilter)) return;\n      _this.paginationСhangeHandler(paginationFilter.applyType, paginationFilter.topOffset);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].subscribe('pagination/load-more', function (paginationFilter) {\n      if (!_this.isCurrentProvider(paginationFilter)) return;\n      _this.paginationLoadMoreHandler(paginationFilter.topOffset);\n    }, true);\n  }\n\n  // Filters initialization\n  _createClass(FilterGroup, [{\n    key: \"addFilter\",\n    value: function addFilter(newFilter) {\n      // remove duplicate\n      this.filters = this.filters.filter(function (filter) {\n        var isDuplicate = newFilter.path === filter.path;\n        if (isDuplicate && newFilter.setData) newFilter.setData(filter.data);\n        return !isDuplicate;\n      });\n\n      // filter add\n      newFilter.uniqueKey = this.getFilterUniqueKey(newFilter);\n\n      // synchronization of a new filter with the first same\n      var firstSameFilter = this.filters.find(function (filter) {\n        return newFilter.uniqueKey === filter.uniqueKey;\n      });\n      if (firstSameFilter) {\n        if (newFilter.syncWithSameFilter) {\n          newFilter.syncWithSameFilter(firstSameFilter);\n        } else if (newFilter.setData && firstSameFilter.data !== newFilter.data) {\n          newFilter.setData(firstSameFilter.data);\n        }\n      }\n\n      // push new filter to the collection\n      this.filters.push(newFilter);\n\n      // Init filter modules\n      this.initIndexer(newFilter);\n      this.initTabIndex(newFilter);\n      this.debounceProcessFilters();\n    }\n  }, {\n    key: \"processFilters\",\n    value: function processFilters() {\n      if (!this.filters.length) return;\n\n      // update current query\n      this.currentQuery = this.query;\n\n      // update filters with current data\n      this.setFiltersData();\n\n      // update additional filters\n      this.additionalFilters.updateProvider();\n\n      // set predefined data for group\n      this.predefinedData.set();\n    }\n\n    // Reinit filters\n  }, {\n    key: \"reinitFilters\",\n    value: function reinitFilters() {\n      var filterNames = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n      if (filterNames && !Array.isArray(filterNames)) filterNames = [filterNames];\n      this.filters.forEach(function (filter) {\n        if (filterNames && !filterNames.includes(filter.name)) return;\n        if (filter.reinit) filter.reinit();\n      });\n      this.processFilters();\n    }\n\n    // Events Handlers\n  }, {\n    key: \"applyFilterHandler\",\n    value: function applyFilterHandler(applyType) {\n      this.resetFiltersByName('pagination');\n      this.apply(applyType);\n    }\n  }, {\n    key: \"applyFiltersHandler\",\n    value: function applyFiltersHandler(applyType) {\n      var redirectPath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      var redirectInNewWindow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n      this.resetFiltersByName('pagination');\n      this.updateFiltersData();\n      if (redirectPath) {\n        this.doRedirect(applyType, redirectPath, redirectInNewWindow);\n      } else {\n        this.apply(applyType);\n      }\n    }\n  }, {\n    key: \"removeFiltersHandler\",\n    value: function removeFiltersHandler(applyType) {\n      this.resetFiltersByName('pagination');\n      this.resetFilters();\n      this.apply(applyType);\n    }\n  }, {\n    key: \"pagination\\u0421hangeHandler\",\n    value: function paginationСhangeHandler(applyType) {\n      var topOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      this.apply(applyType);\n\n      // scroll to provider\n      if (applyType !== 'reload' && (topOffset || topOffset === 0)) $('html, body').stop().animate({\n        scrollTop: this.$provider.offset().top - topOffset\n      }, 500);\n    }\n  }, {\n    key: \"paginationLoadMoreHandler\",\n    value: function paginationLoadMoreHandler() {\n      var autoscroll = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n      this.doAjax({\n        append: true,\n        autoscroll: autoscroll\n      });\n    }\n\n    // Actions\n  }, {\n    key: \"apply\",\n    value: function apply() {\n      var applyType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'ajax';\n      this.emitActiveItems();\n      if (applyType === 'reload') {\n        this.doReload();\n      } else {\n        this.doAjax();\n      }\n    }\n  }, {\n    key: \"doRedirect\",\n    value: function doRedirect(applyType, redirectPath) {\n      var redirectInNewWindow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n      if (applyType === 'reload') {\n        includes_request__WEBPACK_IMPORTED_MODULE_7__[\"default\"].redirectWithGET(this.getUrl(true), redirectPath, redirectInNewWindow);\n      } else {\n        var params = _objectSpread(_defineProperty({}, this.urlPrefix, this.providerKey), this.query);\n        includes_request__WEBPACK_IMPORTED_MODULE_7__[\"default\"].redirectWithPOST(params, redirectPath, redirectInNewWindow);\n      }\n    }\n  }, {\n    key: \"doReload\",\n    value: function doReload() {\n      var url = this.getUrl(true);\n      var newLocation = this.baseUrl;\n      if (url) newLocation = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.applyAliases)(this.baseUrl + url);\n      document.location = newLocation;\n    }\n  }, {\n    key: \"doAjax\",\n    value: function doAjax() {\n      var _this2 = this;\n      var props = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n      var query = this.query;\n      this.$provider = this.getProvider();\n      if (!this.isProviderExist || (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.isEqual)(query, this.currentQuery)) return;\n      this.currentQuery = query;\n      if (!this.additionalRequest) this.updateUrl();\n      this.ajaxRequest(function (response) {\n        _this2.ajaxRequestCompleted(_objectSpread({}, response), props);\n      });\n    }\n  }, {\n    key: \"ajaxRequest\",\n    value: function ajaxRequest(callback) {\n      var _this3 = this;\n      var query = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.query;\n      this.startAjaxLoading();\n      includes_request__WEBPACK_IMPORTED_MODULE_7__[\"default\"].ajax({\n        query: query,\n        provider: this.provider,\n        queryId: this.queryId,\n        indexingFilters: this.indexingFilters\n      }).then(function (response) {\n        callback(response);\n        _this3.endAjaxLoading();\n      }).catch(function (error) {\n        if (!error) return;\n        console.error(error);\n        _this3.endAjaxLoading();\n      });\n    }\n  }, {\n    key: \"startAjaxLoading\",\n    value: function startAjaxLoading() {\n      this.isAjaxLoading = true;\n      this.providerPreloader.show();\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('ajaxFilters/start-loading', this.provider, this.queryId);\n    }\n  }, {\n    key: \"endAjaxLoading\",\n    value: function endAjaxLoading() {\n      this.isAjaxLoading = false;\n      this.providerPreloader.hide();\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('ajaxFilters/end-loading', this.provider, this.queryId);\n    }\n  }, {\n    key: \"ajaxRequestCompleted\",\n    value: function ajaxRequestCompleted(response) {\n      var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n      // update pagination props\n      if (response.pagination && (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'props', this.provider, this.queryId)) {\n        window.JetSmartFilterSettings.props[this.provider][this.queryId] = _objectSpread({}, response.pagination);\n      }\n\n      // update indexed data\n      if (response.jetFiltersIndexedData && (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'jetFiltersIndexedData', this.providerKey)) {\n        window.JetSmartFilterSettings.jetFiltersIndexedData[this.providerKey] = response.jetFiltersIndexedData[this.providerKey];\n      }\n\n      // update provider content\n      if (response.content) {\n        this.renderResult(response.content, props);\n      }\n\n      // update provider data\n      if (response.is_data) {\n        this.$provider.trigger('jet-filter-data-updated', [response, this]);\n      }\n\n      // update fragments\n      if (response.fragments) {\n        for (var selector in response.fragments) {\n          var $el = jQuery(selector);\n          if ($el.length) {\n            $el.html(response.fragments[selector]);\n          }\n        }\n      }\n\n      // backward compatibility for jet-engine-maps\n      if (this.provider) {\n        this.$provider.closest('.elementor-widget-jet-engine-maps-listing, .jet-map-listing, .brxe-jet-engine-maps-listing').trigger('jet-filter-custom-content-render', response);\n      }\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('ajaxFilters/updated', this.provider, this.queryId, response);\n    }\n  }, {\n    key: \"renderResult\",\n    value: function renderResult(result) {\n      var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n      if (!this.$provider.length) return;\n\n      // update the provider selector if for some reason it doesn't actually exist on the page\n      if (!$(document).find(this.$provider).length) this.$provider = this.getProvider();\n      if (props.append) {\n        var $container = this.$provider,\n          $newItems = false;\n\n        // .not to exclude nesting\n        if (this.providerSelectorData.list) $container = $container.find(this.providerSelectorData.list).not(this.providerSelectorData.list + ' ' + this.providerSelectorData.list);\n        if (this.providerSelectorData.item) {\n          $newItems = $(result).find(this.providerSelectorData.item).not(this.providerSelectorData.item + ' ' + this.providerSelectorData.item);\n        } else {\n          var listSelector = this.providerSelectorData.list || this.providerSelectorData.selector;\n          $newItems = $('<div class=\"container\">' + result + '</div>').find(listSelector).not(listSelector + ' ' + listSelector).children();\n        }\n        if (props.autoscroll || props.autoscroll === 0) {\n          var scrollOffset = typeof props.autoscroll === 'number' ? props.autoscroll : 0;\n          $('html, body').stop().animate({\n            scrollTop: $container.offset().top + $container.outerHeight(true) - scrollOffset\n          }, 500);\n        }\n        $container.append($newItems);\n      } else if ('insert' === this.providerSelectorData.action) {\n        if ('epro-portfolio' === this.provider) result = $(result).children().children();\n        this.$provider.html(result);\n      } else {\n        this.$provider.replaceWith(result);\n        this.$provider = this.getProvider();\n      }\n\n      // trigger elementor widgets\n      if (window.elementorFrontend) {\n        switch (this.provider) {\n          case 'jet-engine':\n            if (this.$provider.closest('.elementor-widget-jet-listing-grid').length) {\n              window.elementorFrontend.hooks.doAction('frontend/element_ready/jet-listing-grid.default', this.$provider, $);\n            }\n            break;\n          case 'epro-portfolio':\n            window.elementorFrontend.hooks.doAction('frontend/element_ready/portfolio.default', this.$provider.closest('.elementor-widget-portfolio'), $);\n            break;\n          case 'epro-loop-builder':\n            var $eproLoopBuilder = this.$provider.closest('.elementor-widget-loop-grid');\n            if ($eproLoopBuilder.length) window.elementorFrontend.hooks.doAction('frontend/element_ready/' + $eproLoopBuilder.data('widget_type'), $eproLoopBuilder, $);\n            break;\n        }\n        this.$provider.find('[data-element_type]').each(function (index, item) {\n          var $this = $(item);\n          var elementType = $this.data('element_type');\n          if ('widget' === elementType) {\n            elementType = $this.data('widget_type');\n            window.elementorFrontend.hooks.doAction('frontend/element_ready/widget', $this, $);\n          }\n          window.elementorFrontend.hooks.doAction('frontend/element_ready/global', $this, $);\n          window.elementorFrontend.hooks.doAction('frontend/element_ready/' + elementType, $this, $);\n        });\n        var elementorLazyLoad = new Event(\"elementor/lazyload/observe\");\n        document.dispatchEvent(elementorLazyLoad);\n      }\n\n      // Trigger Bricks elements in Listing grid\n      if (window.bricksIsFrontend && this.provider === 'jet-engine') {\n        document.dispatchEvent(new CustomEvent(\"bricks/ajax/query_result/displayed\"));\n      }\n      if (window.JetPlugins) {\n        window.JetPlugins.init(this.$provider);\n        if (this.$provider.closest('[data-is-block*=\"/\"]').length) {\n          window.JetPlugins.initBlock(this.$provider.closest('[data-is-block*=\"/\"]')[0], true);\n        }\n      }\n\n      // emit rendered event\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('provider/content-rendered', this.provider, this.$provider);\n      // for backward compatibility with other plugins\n      $(document).trigger('jet-filter-content-rendered', [this.$provider, this, this.provider, this.queryId]);\n    }\n  }, {\n    key: \"setFiltersData\",\n    value: function setFiltersData() {\n      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.currentQuery;\n      this.filters.forEach(function (filter) {\n        if (filter.isHierarchy || filter.disabled) return;\n        var key = filter.queryKey,\n          value = data[key];\n        if (value && filter.setData) filter.setData(value);\n      });\n      this.emitActiveItems();\n      //this.emitHierarchyFiltersUpdate();\n    }\n  }, {\n    key: \"updateFiltersData\",\n    value: function updateFiltersData() {\n      this.filters.forEach(function (filter) {\n        if (filter.processData) filter.processData();\n      });\n    }\n  }, {\n    key: \"resetFilters\",\n    value: function resetFilters() {\n      this.filters.forEach(function (filter) {\n        if (filter.reset) filter.reset();\n      });\n    }\n  }, {\n    key: \"updateSameFilters\",\n    value: function updateSameFilters(changedFilter) {\n      this.getSameFilters(changedFilter).forEach(function (filter) {\n        if (changedFilter.data === filter.data) return;\n        if (filter.setData) {\n          filter.setData(changedFilter.data);\n        } else {\n          filter.data = changedFilter.data;\n        }\n      });\n    }\n  }, {\n    key: \"syncSameFilters\",\n    value: function syncSameFilters(changedFilter) {\n      this.getSameFilters(changedFilter, true).forEach(function (filter) {\n        if (filter.syncWithSameFilter) filter.syncWithSameFilter(changedFilter);\n      });\n    }\n  }, {\n    key: \"getFiltersByName\",\n    value: function getFiltersByName(name) {\n      return this.filters.filter(function (filter) {\n        return filter.name === name;\n      });\n    }\n  }, {\n    key: \"resetFiltersByName\",\n    value: function resetFiltersByName(name) {\n      var filters = this.getFiltersByName(name);\n      filters.forEach(function (filter) {\n        if (filter.reset) filter.reset();\n      });\n    }\n\n    // Url methods\n  }, {\n    key: \"updateUrl\",\n    value: function updateUrl() {\n      var filteringApplied = this.filters.some(function (filter) {\n        if (filter.data) return true;\n      });\n      if (filteringApplied) {\n        var url = this.getUrl();\n        if (url) history.replaceState(null, null, (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.applyAliases)(this.baseUrl + url));\n      } else {\n        history.replaceState(null, null, this.baseUrl + this.baseUrlParams);\n      }\n    }\n  }, {\n    key: \"getUrl\",\n    value: function getUrl() {\n      var allFilters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n      var urlData = {};\n      this.uniqueFilters.forEach(function (filter) {\n        if (!(allFilters || filter.isMixed || filter.isReload)) return;\n        var data = filter.data;\n        if (!data) return;\n        var queryType = filter.queryType,\n          queryVar = filter.queryVar;\n        switch (queryType) {\n          case 'tax_query':\n            queryType = 'tax';\n            break;\n          case 'meta_query':\n            queryType = 'meta';\n            break;\n          case 'date_query':\n            queryType = 'date';\n            queryVar = false;\n            data = data.replaceAll('/', '-');\n            break;\n          case 'sort':\n            var sortData = JSON.parse(data);\n            queryVar = false;\n            data = '';\n            for (var sortKey in sortData) {\n              data += sortKey + ':' + sortData[sortKey] + ';';\n            }\n            data = data.replace(/;\\s*$/, '');\n            break;\n          case '_s':\n            //queryType = 'search';\n            queryVar = false;\n            break;\n        }\n        switch (filter.name) {\n          case 'range':\n            queryVar += '!range';\n            break;\n          case 'check-range':\n            queryVar += '!check-range';\n            break;\n          case 'date-range':\n          case 'date-period':\n            if (queryType === 'meta') queryVar += '!date';\n            break;\n          case 'pagination':\n            queryType = 'pagenum';\n            break;\n          case 'search':\n            if (filter.queryType === 'meta_query') {\n              queryType = '_s';\n              queryVar = false;\n              data += '!meta=' + filter.queryVar;\n            }\n            break;\n          default:\n            if (filter.queryVarSuffix) queryVar += '!' + filter.queryVarSuffix;\n            break;\n        }\n        var nesting = [queryType];\n        if (queryVar) nesting.push(queryVar);\n        if (filter.mergeSameQueryKeys && includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting.apply(void 0, [urlData].concat(nesting))) data = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.mergeData)(data, 'operator_AND');\n        (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.setNesting)(data, urlData, nesting, {\n          merge: filter.mergeSameQueryKeys\n        });\n      });\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.isEmpty)(urlData)) return this.baseUrlParams || '';\n      var url = '',\n        providerName = this.provider;\n      if (this.queryId && this.queryId !== 'default') providerName += ':' + this.queryId;\n      switch (this.urlType) {\n        case 'permalink':\n          url = this.urlPrefix + '/' + providerName + '/';\n\n          // replace _s on search\n          if ('_s' in urlData) {\n            urlData.search = urlData._s;\n            delete urlData._s;\n          }\n          for (var queryTypeKey in urlData) {\n            var queryTypeValue = urlData[queryTypeKey];\n            url += queryTypeKey + '/';\n            if (!(0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.isObject)(queryTypeValue)) {\n              url += encodeURIComponent(queryTypeValue) + '/';\n            } else {\n              if (Array.isArray(queryTypeValue)) {\n                url += encodeURIComponent(queryTypeValue.join()) + '/';\n              } else {\n                for (var queryVarKey in queryTypeValue) {\n                  var queryVarValue = encodeURIComponent(queryTypeValue[queryVarKey]);\n                  url += queryVarKey + ':' + queryVarValue + ';';\n                }\n              }\n              url = url.replace(/;\\s*$/, '/');\n            }\n          }\n          if (this.baseUrlParams) url += this.baseUrlParams;\n          break;\n        default:\n          if (this.baseUrlParams) {\n            url = this.baseUrlParams + '&' + this.urlPrefix + '=' + providerName;\n          } else {\n            url = '?' + this.urlPrefix + '=' + providerName;\n          }\n          for (var _queryTypeKey in urlData) {\n            var _queryTypeValue = urlData[_queryTypeKey];\n            url += '&' + _queryTypeKey + '=';\n            if (!(0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.isObject)(_queryTypeValue)) {\n              url += encodeURIComponent(_queryTypeValue);\n            } else {\n              if (Array.isArray(_queryTypeValue)) {\n                url += encodeURIComponent(_queryTypeValue.join());\n              } else {\n                for (var _queryVarKey in _queryTypeValue) {\n                  var _queryVarValue = encodeURIComponent(_queryTypeValue[_queryVarKey]);\n                  url += _queryVarKey + ':' + _queryVarValue + ';';\n                }\n              }\n              url = url.replace(/;\\s*$/, '');\n            }\n          }\n          break;\n      }\n      return url;\n    }\n\n    // module initialization\n  }, {\n    key: \"initIndexer\",\n    value: function initIndexer(filter) {\n      var indexedClass = 'jet-filter-indexed';\n      if (filter.indexer || !filter.$container || !filter.$container.hasClass(indexedClass)) return;\n\n      // Init Indexer Class\n      filter.indexer = new modules_Indexer__WEBPACK_IMPORTED_MODULE_2__[\"default\"](filter);\n    }\n  }, {\n    key: \"initTabIndex\",\n    value: function initTabIndex(filter) {\n      var use_tabindex = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'use_tabindex');\n      if (filter.tabindex || use_tabindex !== 'true') return;\n      filter.tabindex = new modules_TabIndex__WEBPACK_IMPORTED_MODULE_3__[\"default\"](filter);\n    }\n\n    // emitters\n  }, {\n    key: \"emitActiveItems\",\n    value: function emitActiveItems() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('activeItems/change', this.activeItems, this.provider, this.queryId);\n    }\n  }, {\n    key: \"emitHierarchyFiltersUpdate\",\n    value: function emitHierarchyFiltersUpdate() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_6__[\"default\"].publish('hierarchyFilters/update', this.hierarchyFilters);\n    }\n  }, {\n    key: \"isCurrentProvider\",\n    value: function isCurrentProvider(filter) {\n      return filter.provider === this.provider && filter.queryId === this.queryId ? true : false;\n    }\n\n    // Additional methods\n  }, {\n    key: \"getProviderSelector\",\n    value: function getProviderSelector() {\n      var delimiter = this.providerSelectorData.inDepth ? ' ' : '';\n      return 'default' === this.queryId ? this.providerSelectorData.selector : this.providerSelectorData.idPrefix + this.queryId + delimiter + this.providerSelectorData.selector;\n    }\n  }, {\n    key: \"getProvider\",\n    value: function getProvider() {\n      var _this4 = this;\n      return $(this.providerSelector).filter(function (index, element) {\n        return !$(element).parents(_this4.providerSelector).length;\n      });\n    }\n\n    // Getters\n  }, {\n    key: \"query\",\n    get: function get() {\n      var query = {};\n      this.uniqueFilters.forEach(function (filter) {\n        var data = filter.data,\n          key = filter.queryKey;\n        if (!data || !key) return;\n        if (query[key] && filter.mergeSameQueryKeys) {\n          query[key] = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.mergeData)(query[key], data, 'operator_AND');\n        } else {\n          query[key] = data;\n        }\n      });\n      return query;\n    }\n  }, {\n    key: \"providerKey\",\n    get: function get() {\n      return this.provider + '/' + this.queryId;\n    }\n  }, {\n    key: \"providerSelectorData\",\n    get: function get() {\n      return (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getNesting)(JetSmartFilterSettings, 'selectors', this.provider);\n    }\n  }, {\n    key: \"urlParams\",\n    get: function get() {\n      var urlParams = (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.getUrlParams)();\n      if (urlParams[this.urlPrefix] !== this.provider + ':' + this.queryId) return false;\n      delete urlParams[this.urlPrefix];\n      return urlParams;\n    }\n  }, {\n    key: \"activeItems\",\n    get: function get() {\n      var _this5 = this;\n      var activeItems = [];\n      this.uniqueFilters.forEach(function (filter) {\n        if (!filter.data || !filter.reset || _this5.activeItemsExceptions.includes(filter.name)) return;\n        activeItems.push(filter);\n      });\n      return activeItems;\n    }\n  }, {\n    key: \"hierarchyFilters\",\n    get: function get() {\n      var hierarchyFilters = {};\n      this.uniqueFilters.forEach(function (filter) {\n        if (filter.isHierarchy && !filter.isAdditional) {\n          if (!hierarchyFilters[filter.filterId]) hierarchyFilters[filter.filterId] = [];\n          hierarchyFilters[filter.filterId].push(filter);\n        }\n      });\n      return (0,includes_utility__WEBPACK_IMPORTED_MODULE_8__.isNotEmpty)(hierarchyFilters) ? hierarchyFilters : false;\n    }\n  }, {\n    key: \"indexingFilters\",\n    get: function get() {\n      var indexingFilters = [];\n      this.uniqueFilters.forEach(function (filter) {\n        if (filter.indexer) indexingFilters.push(filter.filterId);\n      });\n      if (!indexingFilters.length) return false;\n      return JSON.stringify(indexingFilters);\n    }\n  }, {\n    key: \"isProviderExist\",\n    get: function get() {\n      return this.$provider.length ? true : false;\n    }\n\n    // methods for filter uniqueness\n  }, {\n    key: \"getFilterUniqueKey\",\n    value: function getFilterUniqueKey(filter) {\n      var uniqueKey = filter.name;\n      if (filter.filterId) uniqueKey += '-' + filter.filterId;\n      if (filter.isHierarchy) uniqueKey += '/hierarchical-depth-' + filter.depth;\n      ['provider', 'queryId', 'queryKey'].forEach(function (key) {\n        if (filter[key]) uniqueKey += '/' + filter[key];\n      });\n      return uniqueKey;\n    }\n  }, {\n    key: \"uniqueFilters\",\n    get: function get() {\n      return _toConsumableArray(new Map(this.filters.map(function (filter) {\n        return [filter.uniqueKey, filter];\n      })).values());\n    }\n  }, {\n    key: \"getSameFilters\",\n    value: function getSameFilters(searchFilter) {\n      var excludeIncoming = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      return this.filters.filter(function (filter) {\n        if (searchFilter.uniqueKey !== filter.uniqueKey) return false;\n        if (excludeIncoming && searchFilter.path === filter.path) return false;\n        return true;\n      });\n    }\n  }]);\n  return FilterGroup;\n}();\n\n\n//# sourceURL=webpack:///./js/FilterGroup.js?")}),"./js/bases/ActiveItems.js":
/*!*********************************!*\
  !*** ./js/bases/ActiveItems.js ***!
  \*********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ActiveItems)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_template_parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/template-parser */ \"./js/includes/template-parser.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nvar ActiveItems = /*#__PURE__*/function () {\n  function ActiveItems($activeItems) {\n    var _this = this;\n    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    _classCallCheck(this, ActiveItems);\n    _defineProperty(this, \"activeItems\\u0421ollection\", {});\n    var _props$separateMultip = props.separateMultiple,\n      separateMultiple = _props$separateMultip === void 0 ? false : _props$separateMultip,\n      _props$templateName = props.templateName,\n      templateName = _props$templateName === void 0 ? false : _props$templateName,\n      _props$listClass = props.listClass,\n      listClass = _props$listClass === void 0 ? 'active-list' : _props$listClass,\n      _props$labelClass = props.labelClass,\n      labelClass = _props$labelClass === void 0 ? 'active-title' : _props$labelClass,\n      _props$itemClass = props.itemClass,\n      itemClass = _props$itemClass === void 0 ? 'active-item' : _props$itemClass,\n      _props$clearClass = props.clearClass,\n      clearClass = _props$clearClass === void 0 ? 'active-clear' : _props$clearClass;\n    this.$activeItemsContainer = $activeItems;\n    this.path = (0,includes_utility__WEBPACK_IMPORTED_MODULE_2__.getElementPath)(this.$activeItemsContainer.get(0));\n    this.$elementorWidget = this.$activeItemsContainer.closest('.hide-widget');\n    this.separateMultiple = separateMultiple;\n    this.listClass = listClass;\n    this.labelClass = labelClass;\n    this.itemClass = itemClass;\n    this.clearClass = clearClass;\n    this.provider = this.$activeItemsContainer.data('contentProvider');\n    this.queryId = this.$activeItemsContainer.data('queryId').toString() || 'default';\n    this.providerKey = this.provider + '/' + this.queryId;\n    this.additionalProviders = this.$activeItemsContainer.data('additional-providers');\n    this.allProviders = [this.providerKey];\n    this.applyType = this.$activeItemsContainer.data('applyType') || 'ajax';\n    this.filtersLabel = this.$activeItemsContainer.data('label');\n    this.clearItemLabel = this.$activeItemsContainer.data('clearItemLabel');\n    this.templates = (0,includes_utility__WEBPACK_IMPORTED_MODULE_2__.getNesting)(JetSmartFilterSettings, 'templates', templateName);\n    this.setAllProviders();\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('activeItems/change', function (activeItems, provider, queryId) {\n      if (!_this.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      _this.addToСollection(activeItems, provider + '/' + queryId);\n      _this.buildItems();\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('activeItems/rebuild', function (provider, queryId) {\n      if (!_this.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      _this.buildItems();\n    });\n  }\n  _createClass(ActiveItems, [{\n    key: \"addTo\\u0421ollection\",\n    value: function addToСollection(activeItems, providerKey) {\n      var items = activeItems.filter(function (item) {\n        return !item.isAdditional;\n      });\n      if (this.isThereHierarchicalFilters(items)) items = this.groupHierarchicalFilters(items);\n      this.activeItemsСollection[providerKey] = items;\n    }\n  }, {\n    key: \"buildItems\",\n    value: function buildItems() {\n      var _this2 = this;\n      this.$elementorWidget.removeClass('hide-widget');\n\n      // remove all jQuery events to avoid memory leak\n      this.$activeItemsContainer.find('*').off();\n      var activeItems = this.activeItems;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_2__.isEmpty)(activeItems)) {\n        this.$activeItemsContainer.html('');\n        this.$elementorWidget.addClass('hide-widget');\n        return;\n      }\n      var elList = document.createElement('div');\n      elList.className = this.listClass;\n      if (this.filtersLabel) {\n        var elLabel = document.createElement('div');\n        elLabel.className = this.labelClass;\n        elLabel.innerHTML = this.filtersLabel;\n        elList.appendChild(elLabel);\n      }\n      if (this.clearItemLabel) {\n        elList.appendChild(this.buildItem({\n          value: this.clearItemLabel,\n          itemClass: this.clearClass,\n          callback: function callback() {\n            includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiters/remove', _this2);\n          }\n        }));\n      }\n      activeItems.forEach(function (activeItem) {\n        var item = null;\n        if (Array.isArray(activeItem)) {\n          item = _this2.groupedItem(activeItem);\n        } else if (_this2.isSeparate(activeItem)) {\n          item = _this2.separatedItems(activeItem);\n        } else {\n          item = _this2.regularItem(activeItem);\n        }\n        if (item) elList.appendChild(item);\n      });\n      this.$activeItemsContainer.html(elList);\n\n      // Emit active items build event\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('activeItems/itemsBuilt', this);\n    }\n  }, {\n    key: \"buildItem\",\n    value: function buildItem(props) {\n      var value = props.value,\n        _props$label = props.label,\n        label = _props$label === void 0 ? false : _props$label,\n        _props$itemClass2 = props.itemClass,\n        itemClass = _props$itemClass2 === void 0 ? this.itemClass : _props$itemClass2,\n        _props$templates = props.templates,\n        templates = _props$templates === void 0 ? this.templates : _props$templates,\n        _props$callback = props.callback,\n        callback = _props$callback === void 0 ? function () {} : _props$callback;\n      var activeItemContent = '';\n      if (templates) {\n        if (label && templates.label) activeItemContent += includes_template_parser__WEBPACK_IMPORTED_MODULE_1__[\"default\"].replaceWithValue(templates.label, label);\n        if (value && templates.value) activeItemContent += includes_template_parser__WEBPACK_IMPORTED_MODULE_1__[\"default\"].replaceWithValue(templates.value, value);\n        if (templates.remove) activeItemContent += templates.remove;\n      } else {\n        activeItemContent = value;\n      }\n      var elActiveItem = document.createElement('div');\n      elActiveItem.className = itemClass;\n      elActiveItem.innerHTML = activeItemContent;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_2__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'use_tabindex') === 'true') elActiveItem.tabIndex = 0;\n\n      // add jQuery click event once\n      $(elActiveItem).one('click', callback);\n      return elActiveItem;\n    }\n  }, {\n    key: \"regularItem\",\n    value: function regularItem(filter) {\n      var _this3 = this;\n      var value = (0,includes_utility__WEBPACK_IMPORTED_MODULE_2__.encodeHtmlEntities)(filter.activeValue);\n      var label = filter.activeLabel;\n      if (!value) return false;\n      return this.buildItem({\n        value: value,\n        label: label,\n        callback: function callback() {\n          _this3.removeFilter(filter);\n        }\n      });\n    }\n  }, {\n    key: \"separatedItems\",\n    value: function separatedItems(filter) {\n      var _this4 = this;\n      var items = document.createDocumentFragment();\n      filter.data.forEach(function (itemValue) {\n        var value = filter.getValueLabel(itemValue),\n          label = filter.activeLabel;\n        if (value) items.appendChild(_this4.buildItem({\n          value: value,\n          label: label,\n          callback: function callback() {\n            _this4.removeFilter(filter, itemValue);\n          }\n        }));\n      });\n      return items;\n    }\n  }, {\n    key: \"groupedItem\",\n    value: function groupedItem(filtersGroup) {\n      var _this5 = this;\n      var value = '',\n        label;\n      filtersGroup.forEach(function (filter) {\n        var filterValue = filter.activeValue,\n          filterLabel = filter.activeLabel;\n        if (filterValue) {\n          if (value) value += ' > ';\n          value += filterValue;\n        }\n        if (!label && filterLabel) label = filterLabel;\n      });\n      return this.buildItem({\n        value: value,\n        label: label,\n        callback: function callback() {\n          _this5.removeFilter(filtersGroup[0]);\n        }\n      });\n    }\n  }, {\n    key: \"removeFilter\",\n    value: function removeFilter(filter) {\n      var value = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      // reset filter\n      filter.reset(value);\n\n      // filter cloning and overwrite properties\n      var activeFilter = filter.copy;\n      activeFilter.applyType = this.applyType;\n      //activeFilter.additionalProviders = this.additionalProviders;\n\n      // emit reset active filter\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiter/change', activeFilter);\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiter/apply', activeFilter);\n    }\n  }, {\n    key: \"setAllProviders\",\n    value: function setAllProviders() {\n      var _this6 = this;\n      var additionalProviders = (this.additionalProviders && Array.isArray(this.additionalProviders) ? this.additionalProviders : []).map(function (additionalProvider) {\n        var providerData = additionalProvider.split('/', 2),\n          provider = providerData[0],\n          queryId = providerData[1] || _this6.queryId;\n        return provider + '/' + queryId;\n      });\n      this.allProviders = _toConsumableArray(new Set([this.providerKey].concat(_toConsumableArray(additionalProviders))));\n    }\n  }, {\n    key: \"isSeparate\",\n    value: function isSeparate(filter) {\n      return this.separateMultiple && Array.isArray(filter.data) ? true : false;\n    }\n  }, {\n    key: \"isThereHierarchicalFilters\",\n    value: function isThereHierarchicalFilters(filters) {\n      return filters.some(function (filter) {\n        return filter.isHierarchy;\n      });\n    }\n  }, {\n    key: \"isCurrentProvider\",\n    value: function isCurrentProvider() {\n      var filter = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {\n        provider: false,\n        queryId: false\n      };\n      var _filter$provider = filter.provider,\n        provider = _filter$provider === void 0 ? false : _filter$provider,\n        _filter$queryId = filter.queryId,\n        queryId = _filter$queryId === void 0 ? 'default' : _filter$queryId;\n      if (!provider) return false;\n      return this.allProviders.includes(provider + '/' + queryId) ? true : false;\n    }\n  }, {\n    key: \"activeItems\",\n    get: function get() {\n      var allActiveItems = [];\n      for (var providerKey in this.activeItemsСollection) allActiveItems = [].concat(_toConsumableArray(allActiveItems), _toConsumableArray(this.activeItemsСollection[providerKey]));\n      return allActiveItems;\n    }\n  }, {\n    key: \"containerElement\",\n    get: function get() {\n      if (!this.$activeItemsContainer) return false;\n      if (!this.$activeItemsContainer.length) return false;\n      return this.$activeItemsContainer.get(0);\n    }\n\n    // Additional methods\n  }, {\n    key: \"groupHierarchicalFilters\",\n    value: function groupHierarchicalFilters(filters) {\n      var groupedFilters = [];\n      while (filters.length) {\n        var filtersGroup = void 0;\n        var firstFilter = filters.shift(),\n          firstFilterId = firstFilter.filterId;\n        for (var i = 0; i < filters.length; i++) {\n          if (filters[i].filterId === firstFilterId) {\n            var _filtersGroup;\n            if (!filtersGroup) filtersGroup = [firstFilter];\n            (_filtersGroup = filtersGroup).push.apply(_filtersGroup, _toConsumableArray(filters.splice(i, 1)));\n            i--;\n          }\n        }\n        if (filtersGroup) {\n          groupedFilters.push(filtersGroup);\n        } else {\n          groupedFilters.push(firstFilter);\n        }\n      }\n      return groupedFilters;\n    }\n  }]);\n  return ActiveItems;\n}();\n\n\n//# sourceURL=webpack:///./js/bases/ActiveItems.js?")}),"./js/bases/Filter.js":
/*!****************************!*\
  !*** ./js/bases/Filter.js ***!
  \****************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Filter)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar Filter = /*#__PURE__*/function () {\n  function Filter($filter) {\n    var $container = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    _classCallCheck(this, Filter);\n    _defineProperty(this, \"dataValue\", false);\n    _defineProperty(this, \"applySelector\", '.apply-filters');\n    _defineProperty(this, \"applyButtonSelector\", '.apply-filters__button');\n    _defineProperty(this, \"filtersGroupSelector\", '.jet-filters-group');\n    this.$container = $container;\n    this.$filter = $filter;\n    this.path = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getElementPath)(this.$filter.get(0));\n    this.provider = this.$filter.data('content-provider');\n    this.additionalProviders = this.$filter.data('additional-providers');\n    this.filterId = this.$filter.data('filterId');\n    this.queryId = this.$filter.data('queryId') || 'default';\n    this.queryType = this.$filter.data('queryType');\n    this.queryVar = this.$filter.data('queryVar');\n    this.queryVarSuffix = this.$filter.data('queryVarSuffix');\n    this.applyType = this.$filter.data('applyType') || 'ajax';\n    this.applyOnChanging = this.$filter.data('applyOn') !== 'submit';\n    this.layoutOptions = this.$filter.data('layoutOptions');\n    this.redirect = this.$filter.data('redirect');\n    this.redirectPath = this.$filter.data('redirectPath');\n    this.redirectInNewWindow = this.$filter.data('redirectInNewWindow');\n    this.activeLabel = this.$filter.data('activeLabel');\n    this.isMixed = this.applyType === 'mixed' ? true : false;\n    this.isReload = this.applyType === 'reload' ? true : false;\n    this.$applyButton = $();\n    this.isRTL = $('body').hasClass('rtl');\n    if (this.$container) {\n      if (this.$container.next(this.applySelector).length) {\n        this.$applyButton = this.$container.next(this.applySelector).find(this.applyButtonSelector);\n      } else if (this.$container.closest(this.filtersGroupSelector).length) {\n        this.$applyButton = this.$container.closest(this.filtersGroupSelector).next(this.applySelector).find(this.applyButtonSelector);\n      }\n    }\n    if (typeof this.queryId !== 'string') this.queryId = this.queryId.toString();\n  }\n  _createClass(Filter, [{\n    key: \"initEvent\",\n    value: function initEvent() {\n      this.addFilterChangeEvent();\n      if (!this.applyOnChanging) {\n        this.addApplyEvent();\n      }\n    }\n  }, {\n    key: \"removeEvent\",\n    value: function removeEvent() {\n      this.removeChangeEvent();\n      this.$applyButton.off();\n    }\n  }, {\n    key: \"addApplyEvent\",\n    value: function addApplyEvent() {\n      var _this = this;\n      this.$applyButton.on('click', function () {\n        _this.processData();\n        _this.emitFiterApply();\n      });\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.dataValue = false;\n    }\n  }, {\n    key: \"show\",\n    value: function show() {\n      this.$container.removeClass('hide');\n    }\n  }, {\n    key: \"hide\",\n    value: function hide() {\n      this.$container.addClass('hide');\n    }\n  }, {\n    key: \"showPreloader\",\n    value: function showPreloader() {\n      this.$filter.addClass('jet-filters-loading');\n    }\n  }, {\n    key: \"hidePreloader\",\n    value: function hidePreloader() {\n      this.$filter.removeClass('jet-filters-loading');\n    }\n  }, {\n    key: \"isCurrentProvider\",\n    value: function isCurrentProvider() {\n      var filter = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {\n        provider: false,\n        queryId: false\n      };\n      return filter.provider === this.provider && filter.queryId === this.queryId ? true : false;\n    }\n  }, {\n    key: \"isAdditionalProvider\",\n    value: function isAdditionalProvider() {\n      var filter = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {\n        provider: false,\n        queryId: false\n      };\n      var _filter$provider = filter.provider,\n        provider = _filter$provider === void 0 ? false : _filter$provider,\n        _filter$queryId = filter.queryId,\n        queryId = _filter$queryId === void 0 ? 'default' : _filter$queryId;\n      if (!provider) return false;\n      return this.additionalProviders.includes(provider + '/' + queryId) ? true : false;\n    }\n\n    // method for emitting filter change\n  }, {\n    key: \"was\\u0421hanged\",\n    value: function wasСhanged() {\n      var applyChanges = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.applyOnChanging;\n      this.emitFiterChange();\n      if (applyChanges) this.emitFiterApply();\n    }\n\n    // emitters\n  }, {\n    key: \"emitFiterChange\",\n    value: function emitFiterChange() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiter/change', this);\n    }\n  }, {\n    key: \"emitFiterApply\",\n    value: function emitFiterApply() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiter/apply', this);\n    }\n  }, {\n    key: \"emitFitersApply\",\n    value: function emitFitersApply() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiters/apply', this);\n    }\n  }, {\n    key: \"emitFitersRemove\",\n    value: function emitFitersRemove() {\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].publish('fiters/remove', this);\n    }\n\n    // Getters\n  }, {\n    key: \"data\",\n    get: function get() {\n      return this.dataValue && !this.disabled ? this.dataValue : false;\n    }\n  }, {\n    key: \"queryKey\",\n    get: function get() {\n      var queryVarSuffix = this.queryVarSuffix;\n      var key;\n      key = '_' + this.queryType + '_' + this.queryVar;\n      if (queryVarSuffix) key += '|' + queryVarSuffix;\n      return key;\n    }\n  }, {\n    key: \"copy\",\n    get: function get() {\n      return Object.assign(Object.create(Object.getPrototypeOf(this)), this);\n    }\n  }, {\n    key: \"containerElement\",\n    get: function get() {\n      if (!this.$container) return false;\n      if (!this.$container.length) return false;\n      return this.$container.get(0);\n    }\n  }, {\n    key: \"filterGroup\",\n    get: function get() {\n      return (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(window.JetSmartFilters, 'filterGroups', this.provider + '/' + this.queryId);\n    }\n  }, {\n    key: \"isAjaxLoading\",\n    get: function get() {\n      if (!this.filterGroup) return false;\n      return this.filterGroup.isAjaxLoading;\n    }\n\n    // abstract methods\n  }, {\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      return false;\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      return false;\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      return false;\n    }\n  }, {\n    key: \"setData\",\n    value: function setData() {\n      return false;\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      return false;\n    }\n  }]);\n  return Filter;\n}();\n\n\n//# sourceURL=webpack:///./js/bases/Filter.js?")}),"./js/bases/controls/Checkbox.js":
/*!***************************************!*\
  !*** ./js/bases/controls/Checkbox.js ***!
  \***************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ CheckboxControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ \"jquery\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar CheckboxControl = /*#__PURE__*/function (_Filter) {\n  _inherits(CheckboxControl, _Filter);\n  var _super = _createSuper(CheckboxControl);\n  function CheckboxControl($container, $filter, $checkboxes) {\n    var _this;\n    _classCallCheck(this, CheckboxControl);\n    _this = _super.call(this, $filter, $container);\n    _this.$checkboxes = $checkboxes || $filter.find(':checkbox');\n    _this.$checkboxesList = $container.find('.jet-checkboxes-list');\n    _this.relationalOperator = _this.$filter.data('relational-operator');\n    _this.$allOption = _this.getItemByValue('all');\n    _this.canDeselect = _this.$filter.data('can-deselect');\n    _this.hasGroups = Boolean(_this.$checkboxesList.find('.jet-list-tree').length);\n    _this.inputNotEmptyClass = 'jet-input-not-empty';\n    if (_this.$allOption.length) _this.$allOption.data('all-option', '1').val('');\n    _this.processData();\n    _this.initEvent();\n    return _this;\n  }\n  _createClass(CheckboxControl, [{\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this2 = this;\n      this.$checkboxes.on('change', function (item) {\n        if (_this2.relationalOperator === 'AND' && _this2.hasGroups) _this2.uncheckGroup(item.target);\n        _this2.processData();\n        _this2.wasСhanged();\n      });\n      if (this.canDeselect) {\n        this.$checkboxes.on('click', function (evt) {\n          var $checkboxItem = jQuery(evt.target);\n          if ($checkboxItem.val() === _this2.dataValue) $checkboxItem.prop('checked', false).trigger('change');\n        });\n      }\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$checkboxes.off();\n      this.$dropdownLabel.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      var $checked = this.$checked;\n      var dataValue = false;\n      if ($checked.length === 1) {\n        dataValue = $checked.val();\n      } else if ($checked.length > 1) {\n        dataValue = [];\n        $checked.each(function (index) {\n          dataValue.push($checked.get(index).value);\n        });\n        if (this.relationalOperator) dataValue.push('operator_' + this.relationalOperator);\n      }\n      this.dataValue = dataValue;\n      if (!this.dataValue) this.checkAllOption();\n      if (this.additionalFilterSettings) this.additionalFilterSettings.dataUpdated();\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      this.getItemsByValue(newData).forEach(function ($item) {\n        $item.prop('checked', true);\n      });\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n      if (value) {\n        // reset one value\n        this.getItemByValue(value).prop('checked', false);\n        this.processData();\n      } else {\n        // reset filter\n        this.getItemsByValue(this.dataValue).forEach(function ($item) {\n          $item.prop('checked', false);\n        });\n        this.processData();\n      }\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      var _this3 = this;\n      var currentData = this.data,\n        activeValue = '',\n        delimiter = '';\n      if (!Array.isArray(currentData)) currentData = [currentData];\n      currentData.forEach(function (value) {\n        var label = _this3.getValueLabel(value);\n        if (label) {\n          activeValue += delimiter + label;\n          delimiter = ', ';\n        }\n      });\n      return activeValue || false;\n    }\n  }, {\n    key: \"$checked\",\n    get: function get() {\n      return this.$checkboxes.filter(':checked');\n    }\n\n    // Additional methods\n  }, {\n    key: \"getItemsByValue\",\n    value: function getItemsByValue(values) {\n      var _this4 = this;\n      var items = [];\n      if (!Array.isArray(values)) values = [values];\n      values.forEach(function (value) {\n        items.push(_this4.getItemByValue(value));\n      });\n      return items;\n    }\n  }, {\n    key: \"getItemByValue\",\n    value: function getItemByValue(value) {\n      return this.$checkboxes.filter('[value=\"' + value + '\"]');\n    }\n  }, {\n    key: \"getValueLabel\",\n    value: function getValueLabel(value) {\n      return this.$checkboxes.filter('[value=\"' + value + '\"]').data('label');\n    }\n  }, {\n    key: \"checkAllOption\",\n    value: function checkAllOption() {\n      if (!this.$allOption) return;\n      this.$allOption.prop('checked', true);\n    }\n\n    // unchecked group items for intersection relational operator\n  }, {\n    key: \"uncheckGroup\",\n    value: function uncheckGroup(item) {\n      var $item = $(item);\n      var isChildren = Boolean($item.closest('.jet-list-tree__children').length);\n      var isParent = !isChildren ? Boolean($item.closest('.jet-list-tree__parent').length) : false;\n      if (!isParent && !isChildren) return;\n      if (isChildren) {\n        //top nesting\n        $item.parents('.jet-list-tree__children').prev('.jet-list-tree__parent').find('.jet-checkboxes-list__input').prop('checked', false);\n\n        // bottom nesting\n        $item.parent().parent('.jet-list-tree__parent').next('.jet-list-tree__children').find('.jet-checkboxes-list__input').prop('checked', false);\n      }\n      if (isParent) {\n        $item.closest('.jet-list-tree__parent').next('.jet-list-tree__children').find('.jet-checkboxes-list__input').prop('checked', false);\n      }\n    }\n  }]);\n  return CheckboxControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/Checkbox.js?")}),"./js/bases/controls/DateRange.js":
/*!****************************************!*\
  !*** ./js/bases/controls/DateRange.js ***!
  \****************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ DateRangeControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/filters-ui */ \"./js/includes/filters-ui.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar DateRangeControl = /*#__PURE__*/function (_Filter) {\n  _inherits(DateRangeControl, _Filter);\n  var _super = _createSuper(DateRangeControl);\n  function DateRangeControl($container, $filter, $dateRangeInput, $dateRangeSubmit, $dateRangeFrom, $dateRangeTo) {\n    var _this;\n    _classCallCheck(this, DateRangeControl);\n    _this = _super.call(this, $filter, $container);\n    _defineProperty(_assertThisInitialized(_this), \"dateRangeInputSelector\", includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].dateRange.inputSelector);\n    _defineProperty(_assertThisInitialized(_this), \"dateRangeSubmitSelector\", includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].dateRange.submitSelector);\n    _defineProperty(_assertThisInitialized(_this), \"dateRangeFromSelector\", includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].dateRange.fromSelector);\n    _defineProperty(_assertThisInitialized(_this), \"dateRangeToSelector\", includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].dateRange.toSelector);\n    _this.$dateRangeInput = $dateRangeInput || $filter.find(_this.dateRangeInputSelector);\n    _this.$dateRangeSubmit = $dateRangeSubmit || $filter.find(_this.dateRangeSubmitSelector);\n    _this.$dateRangeFrom = $dateRangeFrom || $filter.find(_this.dateRangeFromSelector);\n    _this.$dateRangeTo = $dateRangeTo || $filter.find(_this.dateRangeToSelector);\n    _this.dateFormat = _this.$dateRangeInput.data('date-format') || 'mm/dd/yy';\n    _this.initDateRangeUI();\n    _this.processData();\n    _this.addFilterChangeEvent();\n    return _this;\n  }\n  _createClass(DateRangeControl, [{\n    key: \"initDateRangeUI\",\n    value: function initDateRangeUI() {\n      var _this2 = this;\n      includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].dateRange.init({\n        id: this.$filter.closest('.elementor-widget-jet-smart-filters-date-range').data('id') || this.$filter.closest('.jet-sm-gb-wrapper').data('block-id') || this.$filter.closest('.brxe-jet-smart-filters-date-range').attr('id'),\n        $dateRangeInput: this.$dateRangeInput,\n        $dateRangeFrom: this.$dateRangeFrom,\n        $dateRangeTo: this.$dateRangeTo,\n        onChange: function onChange() {\n          _this2.processData();\n          _this2.emitFiterChange();\n        }\n      });\n    }\n  }, {\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this3 = this;\n      this.$dateRangeSubmit.on('click', function () {\n        _this3.emitFiterApply();\n      });\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$dateRangeSubmit.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      this.dataValue = this.$dateRangeInput.val();\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      this.$dateRangeInput.val(newData);\n      var data = newData.split('-');\n      if (data[0]) this.$dateRangeFrom.val(includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].datePicker.formatDate(new Date(data[0].replaceAll('.', '/')), this.dateFormat));\n      if (data[1]) this.$dateRangeTo.val(includes_filters_ui__WEBPACK_IMPORTED_MODULE_1__[\"default\"].datePicker.formatDate(new Date(data[1].replaceAll('.', '/')), this.dateFormat));\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.dataValue = false;\n      this.$dateRangeInput.val('');\n      this.$dateRangeFrom.val('');\n      this.$dateRangeFrom.datepicker('option', 'maxDate', null);\n      this.$dateRangeTo.val('');\n      this.$dateRangeTo.datepicker('option', 'minDate', null);\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      return (this.$dateRangeFrom.val() + '-' + this.$dateRangeTo.val()).replace(/^-/, '∞ — ').replace(/-$/, ' — ∞').replace('-', ' — ');\n    }\n  }]);\n  return DateRangeControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/DateRange.js?")}),"./js/bases/controls/Range.js":
/*!************************************!*\
  !*** ./js/bases/controls/Range.js ***!
  \************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ RangeControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar RangeControl = /*#__PURE__*/function (_Filter) {\n  _inherits(RangeControl, _Filter);\n  var _super = _createSuper(RangeControl);\n  function RangeControl($container, $filter, $sliderInputMin, $sliderInputMax, $sliderValuesMin, $sliderValuesMax, $sliderTrackRange, $rangeInputMin, $rangeInputMax, prefix, suffix) {\n    var _this;\n    _classCallCheck(this, RangeControl);\n    _this = _super.call(this, $filter, $container);\n    _this.$sliderInputMin = $sliderInputMin || _this.$filter.find('.jet-range__slider__input--min');\n    _this.$sliderInputMax = $sliderInputMax || _this.$filter.find('.jet-range__slider__input--max');\n    _this.$sliderValuesMin = $sliderValuesMin || _this.$filter.find('.jet-range__values-min');\n    _this.$sliderValuesMax = $sliderValuesMax || _this.$filter.find('.jet-range__values-max');\n    _this.$sliderTrackRange = $sliderTrackRange || _this.$filter.find('.jet-range__slider__track__range');\n    _this.$rangeInputMin = $rangeInputMin || _this.$filter.find('.jet-range__inputs__min');\n    _this.$rangeInputMax = $rangeInputMax || _this.$filter.find('.jet-range__inputs__max');\n    _this.$rangeInputs = _this.$rangeInputMin.add(_this.$rangeInputMax);\n    _this.$sliderInputs = _this.$sliderInputMin.add(_this.$sliderInputMax);\n    _this.$inputs = _this.$sliderInputMin.add(_this.$sliderInputMax).add(_this.$rangeInputMin).add(_this.$rangeInputMax);\n    _this.minConstraint = parseFloat(_this.$sliderInputMin.attr('min'));\n    _this.maxConstraint = parseFloat(_this.$sliderInputMax.attr('max'));\n    _this.step = parseFloat(_this.$sliderInputMax.attr('step'));\n    _this.minVal = parseFloat(_this.$sliderInputMin.val());\n    _this.maxVal = parseFloat(_this.$sliderInputMax.val());\n    _this.prefix = prefix || _this.$filter.find('.jet-range__values-prefix').first().text() || false;\n    _this.suffix = suffix || _this.$filter.find('.jet-range__values-suffix').first().text() || false;\n    _this.format = _this.$filter.data('format') || {\n      'thousands_sep': '',\n      'decimal_sep': '',\n      'decimal_num': 0\n    };\n    _this.format.thousands_sep = _this.format.thousands_sep.replace(/&nbsp;/g, ' ');\n    _this.rangeInputsSeparators = _this.$filter.data('inputs-separators');\n    _this.initSlider();\n    _this.processData();\n    _this.initEvent();\n    _this.valuesUpdated();\n    return _this;\n  }\n  _createClass(RangeControl, [{\n    key: \"initSlider\",\n    value: function initSlider() {\n      var _this2 = this;\n      this.$filter.on('mousemove touchstart', this.findClosestRange.bind(this));\n      this.$sliderInputMin.on('input', function (event) {\n        _this2.minVal = parseFloat(_this2.$sliderInputMin.val());\n        _this2.valuesUpdated('min');\n      });\n      this.$sliderInputMax.on('input', function () {\n        _this2.maxVal = parseFloat(_this2.$sliderInputMax.val());\n        _this2.valuesUpdated('max');\n      });\n      if (this.$rangeInputs.length) this.$rangeInputs.on('input keydown blur', function (event) {\n        var elInput = event.target;\n        var value = elInput.value;\n        var inputType = '';\n        if (elInput.hasAttribute('min-range')) inputType = 'min';\n        if (elInput.hasAttribute('max-range')) inputType = 'max';\n        if (!inputType) return;\n        if (_this2.rangeInputsSeparators) {\n          var oldValue = elInput.oldValue || '';\n          var caretPosition = elInput.selectionEnd;\n          if (value !== oldValue) {\n            _this2.rangeInputUpdateValue(inputType, value);\n            var formattedValue = elInput.value;\n            var numericValue = elInput.numericValue;\n            switch (inputType) {\n              case 'min':\n                _this2.minVal = _this2.inputNumberRangeValidation(numericValue);\n                break;\n              case 'max':\n                _this2.maxVal = _this2.inputNumberRangeValidation(numericValue);\n                break;\n            }\n\n            // set caret position\n            if (formattedValue.length === elInput.selectionEnd) {\n              var positionOffset = -1;\n              if (formattedValue !== oldValue) positionOffset = formattedValue.slice(0, caretPosition).split(_this2.format.thousands_sep).length - 1 - (oldValue.slice(0, caretPosition).split(_this2.format.thousands_sep).length - 1);\n              if (formattedValue === oldValue) if ([_this2.format.thousands_sep, _this2.format.decimal_sep].includes(formattedValue.charAt(caretPosition))) positionOffset = 0;\n              elInput.setSelectionRange(caretPosition + positionOffset, caretPosition + positionOffset);\n            }\n          }\n        } else {\n          switch (inputType) {\n            case 'min':\n              _this2.minVal = _this2.inputNumberRangeValidation(value || _this2.minConstraint);\n              break;\n            case 'max':\n              _this2.maxVal = _this2.inputNumberRangeValidation(value || _this2.maxConstraint);\n              break;\n          }\n        }\n        if (event.type === 'blur' || event.keyCode === 13) _this2.valuesUpdated(inputType);\n      });\n    }\n  }, {\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this3 = this;\n      this.$sliderInputs.on('mouseup touchend', function () {\n        _this3.processData();\n        _this3.wasСhanged();\n      });\n      this.$rangeInputs.on('change', function () {\n        _this3.processData();\n        _this3.wasСhanged();\n      });\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$filter.off();\n      this.$inputs.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      if (this.$rangeInputMin.length) this.rangeInputUpdateValue('min', this.minVal);\n      if (this.$rangeInputMax.length) this.rangeInputUpdateValue('max', this.maxVal);\n\n      // Prevent of adding slider defaults\n      if (this.minVal == this.minConstraint && this.maxVal == this.maxConstraint) {\n        this.dataValue = false;\n        return;\n      }\n      this.dataValue = this.minVal + '_' + this.maxVal;\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      var data = newData.split('_');\n      if (data[0]) {\n        this.minVal = parseFloat(data[0]);\n        this.$sliderInputMin.val(this.minVal);\n      }\n      if (data[1]) {\n        this.maxVal = parseFloat(data[1]);\n        this.$sliderInputMax.val(this.maxVal);\n      }\n      this.valuesUpdated();\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.dataValue = false;\n      this.minVal = this.minConstraint;\n      this.maxVal = this.maxConstraint;\n      this.$sliderInputMin.val(this.minVal);\n      this.$sliderInputMax.val(this.maxVal);\n      this.valuesUpdated();\n      this.processData();\n    }\n  }, {\n    key: \"findClosestRange\",\n    value: function findClosestRange(event) {\n      var clientX = false;\n      if (event.type === 'mousemove') clientX = event.clientX;\n      if (event.type === 'touchstart' && event.touches[0]) clientX = event.touches[0].clientX;\n      if (!clientX) return;\n      var bounds = event.target.getBoundingClientRect(),\n        x = clientX - bounds.left,\n        width = parseFloat(this.$sliderInputMax.width()),\n        minValue = parseFloat(this.$sliderInputMin.val()),\n        maxValue = parseFloat(this.$sliderInputMax.val());\n      var averageValue = (maxValue + minValue) / 2,\n        hoverValue = this.isRTL ? (this.minConstraint - this.maxConstraint) * (x / width) + this.maxConstraint : (this.maxConstraint - this.minConstraint) * (x / width) + this.minConstraint;\n      if (hoverValue > averageValue) {\n        this.swapInput('max');\n      } else {\n        this.swapInput('min');\n      }\n    }\n  }, {\n    key: \"swapInput\",\n    value: function swapInput(inputType) {\n      switch (inputType) {\n        case 'min':\n          this.$sliderInputMin.css('z-index', 21);\n          this.$sliderInputMax.css('z-index', 20);\n          break;\n        case 'max':\n          this.$sliderInputMin.css('z-index', 20);\n          this.$sliderInputMax.css('z-index', 21);\n          break;\n      }\n    }\n  }, {\n    key: \"valuesUpdated\",\n    value: function valuesUpdated() {\n      var inputType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n      switch (inputType) {\n        case 'min':\n          if (Number(this.minVal) > Number(this.maxVal) - this.step) this.minVal = Number(this.maxVal) - this.step;\n          this.$sliderInputMin.val(this.minVal);\n          this.rangeInputUpdateValue('min', this.minVal);\n          break;\n        case 'max':\n          if (Number(this.maxVal) < Number(this.minVal) + this.step) this.maxVal = Number(this.minVal) + this.step;\n          this.$sliderInputMax.val(this.maxVal);\n          this.rangeInputUpdateValue('max', this.maxVal);\n          break;\n      }\n      if (this.$sliderValuesMin.length) this.$sliderValuesMin.html(this.getFormattedData(this.minVal));\n      if (this.$sliderValuesMax.length) this.$sliderValuesMax.html(this.getFormattedData(this.maxVal));\n      var low = 100 * ((this.minVal - this.minConstraint) / (this.maxConstraint - this.minConstraint)),\n        high = 100 * ((this.maxVal - this.minConstraint) / (this.maxConstraint - this.minConstraint));\n      this.$sliderTrackRange.css({\n        '--low': low + '%',\n        '--high': high + '%'\n      });\n    }\n  }, {\n    key: \"inputNumberRangeValidation\",\n    value: function inputNumberRangeValidation(val) {\n      if (val < this.minConstraint) return this.minConstraint;\n      if (val > this.maxConstraint) return this.maxConstraint;\n      return val;\n    }\n  }, {\n    key: \"getFormattedData\",\n    value: function getFormattedData(data) {\n      var re = '\\\\d(?=(\\\\d{' + (3 || 0) + '})+' + (this.format.decimal_num > 0 ? '\\\\D' : '$') + ')',\n        num = data.toFixed(Math.max(0, ~~this.format.decimal_num));\n      return (this.format.decimal_sep ? num.replace('.', this.format.decimal_sep) : num).replace(new RegExp(re, 'g'), '$&' + (this.format.thousands_sep || ''));\n    }\n  }, {\n    key: \"restoreFormattedData\",\n    value: function restoreFormattedData(data) {\n      if (typeof data === 'number') return data;\n      if (this.format.thousands_sep) data = data.replace(new RegExp('\\\\' + this.format.thousands_sep, 'g'), '');\n      if (this.format.thousands_sep) data = data.replace(this.format.decimal_sep, '.');\n      return parseFloat(this.removeNonNumeric(data));\n    }\n  }, {\n    key: \"removeNonNumeric\",\n    value: function removeNonNumeric(str) {\n      return str.replace(/[^\\d.-]/g, '');\n    }\n  }, {\n    key: \"rangeInputUpdateValue\",\n    value: function rangeInputUpdateValue(inputType, newValue) {\n      if (!this.$rangeInputs.length) return;\n      var elInput;\n      switch (inputType) {\n        case 'min':\n          elInput = this.$rangeInputMin[0];\n          break;\n        case 'max':\n          elInput = this.$rangeInputMax[0];\n          break;\n        default:\n          return;\n      }\n      if (this.rangeInputsSeparators) {\n        var restoreValue = this.restoreFormattedData(newValue);\n        var formattedValue = this.getFormattedData(restoreValue);\n        if (!isNaN(restoreValue)) {\n          elInput.value = formattedValue;\n          elInput.numericValue = restoreValue;\n        } else {\n          elInput.value = '';\n          switch (inputType) {\n            case 'min':\n              elInput.numericValue = this.minConstraint;\n              break;\n            case 'max':\n              elInput.numericValue = this.maxConstraint;\n              break;\n          }\n        }\n        elInput.oldValue = elInput.value;\n      } else {\n        if (newValue !== '') {\n          elInput.value = newValue;\n        } else {\n          switch (inputType) {\n            case 'min':\n              elInput.value = this.minConstraint;\n              break;\n            case 'max':\n              elInput.value = this.maxConstraint;\n              break;\n          }\n        }\n      }\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      if (typeof this.dataValue === 'string') {\n        var data = this.dataValue.split('_');\n        var value = '';\n        if (data[0]) {\n          if (this.prefix) value += this.prefix;\n          value += this.getFormattedData(parseFloat(data[0]));\n          if (this.suffix) value += this.suffix;\n          if (data[1]) value += ' — ';\n        }\n        if (data[1]) {\n          if (this.prefix) value += this.prefix;\n          value += this.getFormattedData(parseFloat(data[1]));\n          if (this.suffix) value += this.suffix;\n        }\n        return value;\n      } else {\n        return this.dataValue;\n      }\n    }\n  }]);\n  return RangeControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/Range.js?")}),"./js/bases/controls/Rating.js":
/*!*************************************!*\
  !*** ./js/bases/controls/Rating.js ***!
  \*************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ RatingControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar RatingControl = /*#__PURE__*/function (_Filter) {\n  _inherits(RatingControl, _Filter);\n  var _super = _createSuper(RatingControl);\n  function RatingControl($container, $filter, $starsRating) {\n    var _this;\n    _classCallCheck(this, RatingControl);\n    _this = _super.call(this, $filter, $container);\n    _defineProperty(_assertThisInitialized(_this), \"starsRatingSelector\", '.jet-rating-star__input');\n    _this.$starsRating = $starsRating || $filter.find(_this.starsRatingSelector);\n    _this.processData();\n    _this.initEvent();\n    return _this;\n  }\n  _createClass(RatingControl, [{\n    key: \"initEvent\",\n    value: function initEvent() {\n      var _this2 = this;\n      this.$starsRating.off('click');\n      this.$starsRating.on('click', function (evt) {\n        var $starItem = $(evt.target);\n        if ($starItem.hasClass('is-checked')) {\n          _this2.$starsRating.prop('checked', false).removeClass('is-checked');\n        } else {\n          _this2.$starsRating.removeClass('is-checked');\n          $starItem.addClass('is-checked');\n        }\n        _this2.processData();\n        _this2.wasСhanged();\n      });\n      if (!this.applyOnChanging) {\n        this.addApplyEvent();\n      }\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$starsRating.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      this.dataValue = this.$checked.val() || false;\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      this.$checked.removeClass('is-checked');\n      this.$starsRating.filter('[value=\"' + newData + '\"]').addClass('is-checked');\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.dataValue = false;\n      this.$starsRating.prop('checked', false).removeClass('is-checked');\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      var activeValue = this.dataValue || '0',\n        total = this.$starsRating.length;\n      return activeValue + '/' + total;\n    }\n  }, {\n    key: \"$checked\",\n    get: function get() {\n      return this.$starsRating.filter('.is-checked');\n    }\n  }]);\n  return RatingControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/Rating.js?")}),"./js/bases/controls/Search.js":
/*!*************************************!*\
  !*** ./js/bases/controls/Search.js ***!
  \*************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ SearchControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _get() { if (typeof Reflect !== \"undefined\" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }\nfunction _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar SearchControl = /*#__PURE__*/function (_Filter) {\n  _inherits(SearchControl, _Filter);\n  var _super = _createSuper(SearchControl);\n  function SearchControl($container, $filter, $searchInput, $searchSubmit, $searchClear) {\n    var _this;\n    _classCallCheck(this, SearchControl);\n    _this = _super.call(this, $filter, $container);\n    _defineProperty(_assertThisInitialized(_this), \"searchInputSelector\", '.jet-search-filter__input');\n    _defineProperty(_assertThisInitialized(_this), \"searchSubmitSelector\", '.jet-search-filter__submit');\n    _defineProperty(_assertThisInitialized(_this), \"searchClearSelector\", '.jet-search-filter__input-clear');\n    _defineProperty(_assertThisInitialized(_this), \"searchLoadingClass\", 'jet-filters-single-loading');\n    _defineProperty(_assertThisInitialized(_this), \"inputNotEmptyClass\", 'jet-input-not-empty');\n    _defineProperty(_assertThisInitialized(_this), \"delayID\", null);\n    _this.$searchInput = $searchInput || $filter.find(_this.searchInputSelector);\n    _this.$searchSubmit = $searchSubmit || $filter.find(_this.searchSubmitSelector);\n    _this.$searchClear = $searchClear || $filter.find(_this.searchClearSelector);\n    _this.processData();\n    _this.addFilterChangeEvent();\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('ajaxFilters/end-loading', function () {\n      _this.$filter.removeClass(_this.searchLoadingClass);\n    });\n    return _this;\n  }\n  _createClass(SearchControl, [{\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this2 = this;\n      this.$searchSubmit.on('click', function () {\n        _this2.wasСhanged();\n      });\n      this.$searchClear.on('click', function () {\n        _this2.$searchInput.val('');\n        _this2.$searchInput.removeClass(_this2.inputNotEmptyClass);\n        _this2.wasСhanged();\n      });\n      this.$searchInput.on('keyup', function (evt) {\n        var value = evt.target.value;\n        if (value === _this2.dataValue) return;\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('fiter/syncSameFilters', _this2);\n        if (_this2.applyType === 'ajax-ontyping') {\n          if (_this2.minLettersCount <= value.length) {\n            _this2.emitFiterChangeWithDelay();\n            _this2.$searchInput.addClass(_this2.inputNotEmptyClass);\n          } else {\n            if (_this2.$searchInput.hasClass(_this2.inputNotEmptyClass)) {\n              _this2.emitFiterChangeWithDelay();\n            }\n            _this2.$searchInput.removeClass(_this2.inputNotEmptyClass);\n          }\n        } else if (evt.keyCode === 13) {\n          _this2.wasСhanged();\n        }\n      });\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$searchSubmit.off();\n      this.$searchClear.off();\n      this.$searchInput.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      this.dataValue = this.$searchInput.val();\n      if (this.minLettersCount && this.minLettersCount > this.dataValue.length) {\n        this.dataValue = '';\n      }\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      this.$searchInput.val(newData);\n      if (this.applyType === 'ajax-ontyping') {\n        if (this.minLettersCount <= newData.length) {\n          this.$searchInput.addClass(this.inputNotEmptyClass);\n        }\n      }\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.dataValue = false;\n      this.$searchInput.val('');\n      this.$searchInput.removeClass(this.inputNotEmptyClass);\n    }\n  }, {\n    key: \"was\\u0421hanged\",\n    value: function wasСhanged() {\n      this.processData();\n      _get(_getPrototypeOf(SearchControl.prototype), \"was\\u0421hanged\", this).call(this, this.filterGroup.isProviderExist);\n    }\n  }, {\n    key: \"emitFiterChangeWithDelay\",\n    value: function emitFiterChangeWithDelay() {\n      var _this3 = this;\n      var delay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 350;\n      clearTimeout(this.delayID);\n      this.delayID = setTimeout(function () {\n        _this3.$filter.addClass(_this3.searchLoadingClass);\n        _this3.processData();\n        _this3.wasСhanged();\n      }, delay);\n    }\n  }, {\n    key: \"syncWithSameFilter\",\n    value: function syncWithSameFilter(sameFilter) {\n      var sameInputVal = sameFilter.$searchInput.val();\n      var inputVal = this.$searchInput.val();\n      if (inputVal !== sameInputVal) this.$searchInput.val(sameInputVal);\n    }\n  }, {\n    key: \"minLettersCount\",\n    get: function get() {\n      return this.$filter.data('min-letters-count');\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      return this.dataValue;\n    }\n  }]);\n  return SearchControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/Search.js?")}),"./js/bases/controls/Select.js":
/*!*************************************!*\
  !*** ./js/bases/controls/Select.js ***!
  \*************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ SelectControl)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ \"jquery\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nvar SelectControl = /*#__PURE__*/function (_Filter) {\n  _inherits(SelectControl, _Filter);\n  var _super = _createSuper(SelectControl);\n  function SelectControl($container, $filter, $select) {\n    var _this;\n    _classCallCheck(this, SelectControl);\n    _this = _super.call(this, $filter, $container);\n    _this.$select = $select || $filter.find('select');\n    _this.$allOption = _this.getItemByValue('all');\n    _this.isSelect = _this.$select.prop('tagName') === 'SELECT' ? true : false;\n    _this.canDeselect = _this.$filter.data('can-deselect');\n    if (_this.$allOption.length) _this.$allOption.data('all-option', '1').val('');\n    _this.processData();\n    _this.initEvent();\n    return _this;\n  }\n  _createClass(SelectControl, [{\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this2 = this;\n      this.$select.on('change', function () {\n        _this2.processData();\n        _this2.wasСhanged();\n      });\n      if (!this.isSelect && this.canDeselect) {\n        this.$select.on('click', function (evt) {\n          var $radioItem = jQuery(evt.target);\n          if ($radioItem.val() === _this2.dataValue) $radioItem.prop('checked', false).trigger('change');\n        });\n      }\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$select.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      this.dataValue = this.$selected.val();\n      if (!this.dataValue) this.checkAllOption();\n      if (this.additionalFilterSettings) this.additionalFilterSettings.dataUpdated();\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      this.reset();\n      if (!newData) return;\n      var $item = this.getItemByValue(newData);\n      if ($item) $item.prop(this.isSelect ? 'selected' : 'checked', true);\n      this.processData();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.$selected.prop(this.isSelect ? 'selected' : 'checked', false);\n      this.processData();\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      var $item = this.getItemByValue(this.data);\n      if ($item) return $item.data('label');\n    }\n  }, {\n    key: \"$selected\",\n    get: function get() {\n      return this.isSelect ? this.$select.find(':checked') : this.$select.filter(':checked');\n    }\n\n    // Additional methods\n  }, {\n    key: \"getItemByValue\",\n    value: function getItemByValue(value) {\n      var $item = false;\n      if (this.isSelect) {\n        this.$select.find('option').each(function (index, item) {\n          var $option = $(item);\n          if ($option.val() === value) $item = $option;\n        });\n      } else {\n        $item = this.$select.filter('[value=\"' + value + '\"]');\n      }\n      return $item;\n    }\n  }, {\n    key: \"checkAllOption\",\n    value: function checkAllOption() {\n      if (!this.$allOption) return;\n      this.$allOption.prop('checked', true);\n    }\n  }]);\n  return SelectControl;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/bases/controls/Select.js?")}),"./js/extensions/elementorPopup.js":
/*!*****************************************!*\
  !*** ./js/extensions/elementorPopup.js ***!
  \*****************************************/
(()=>{eval("// Elementor popup show event\nwindow.addEventListener('elementor/popup/show', function (event) {\n  var id = event.detail.id;\n  var instance = event.detail.instance;\n\n  // removing the \"jsf-filter\" attributes for filters widgets reinitializing\n  instance.$element.find('[jsf-filter]').removeAttr('jsf-filter');\n});\n\n//# sourceURL=webpack:///./js/extensions/elementorPopup.js?")}),"./js/extensions/index.js":
/*!********************************!*\
  !*** ./js/extensions/index.js ***!
  \********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _elementorPopup_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./elementorPopup.js */ \"./js/extensions/elementorPopup.js\");\n/* harmony import */ var _elementorPopup_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_elementorPopup_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jetEngine_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./jetEngine.js */ \"./js/extensions/jetEngine.js\");\n\n\n\n//# sourceURL=webpack:///./js/extensions/index.js?")}),"./js/extensions/jetEngine.js":
/*!************************************!*\
  !*** ./js/extensions/jetEngine.js ***!
  \************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n\n\n// ajax get listing event\n$(document).on('jet-engine/listing/ajax-get-listing/done', function (evt, $html) {\n  var _window$JetSmartFilte, _window$JetSmartFilte2;\n  var $grid = $html.find('.jet-listing-grid__items');\n  if (!$grid.length) return;\n  var provider = 'jet-engine';\n  var providerId = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)($grid.data('nav'), 'widget_settings', '_element_id') || 'default';\n  var filterGroups = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilters, 'filterGroups', provider + '/' + providerId);\n  if (!filterGroups) return;\n  var paginationFilters = filterGroups.getFiltersByName('pagination');\n  if (!paginationFilters.length) return;\n  var page = $grid.data('page');\n  var max_num_pages = $grid.data('pages');\n  if (!((_window$JetSmartFilte = window.JetSmartFilterSettings.props) !== null && _window$JetSmartFilte !== void 0 && (_window$JetSmartFilte2 = _window$JetSmartFilte[provider]) !== null && _window$JetSmartFilte2 !== void 0 && _window$JetSmartFilte2[providerId])) {\n    return;\n  }\n  window.JetSmartFilterSettings.props[provider][providerId].page = page;\n  window.JetSmartFilterSettings.props[provider][providerId].max_num_pages = max_num_pages;\n  paginationFilters.forEach(function (paginationFilter) {\n    paginationFilter.reinit();\n  });\n});\n\n//# sourceURL=webpack:///./js/extensions/jetEngine.js?")}),"./js/filters-initializer.js":
/*!***********************************!*\
  !*** ./js/filters-initializer.js ***!
  \***********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _FilterGroup__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FilterGroup */ \"./js/FilterGroup.js\");\n/* harmony import */ var filters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! filters */ \"./js/filters/index.js\");\n/* harmony import */ var includes_filters_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! includes/filters-ui */ \"./js/includes/filters-ui.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_epro_compat__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! includes/epro-compat */ \"./js/includes/epro-compat.js\");\n/* harmony import */ var includes_preloader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! includes/preloader */ \"./js/includes/preloader.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n// Main Class\n\n\n// Filters Сlasses\n\n\n// Includes\n\n\n\n\n\n\n// Data\nvar JSF = {\n  filtersList: {\n    CheckBoxes: 'jet-smart-filters-checkboxes',\n    CheckRange: 'jet-smart-filters-check-range',\n    Select: 'jet-smart-filters-select',\n    SelectHierarchical: 'jet-smart-filters-hierarchy',\n    Range: 'jet-smart-filters-range',\n    DateRange: 'jet-smart-filters-date-range',\n    DatePeriod: 'jet-smart-filters-date-period',\n    Radio: 'jet-smart-filters-radio',\n    Rating: 'jet-smart-filters-rating',\n    Visual: 'jet-smart-filters-color-image',\n    Alphabet: 'jet-smart-filters-alphabet',\n    Search: 'jet-smart-filters-search',\n    Sorting: 'jet-smart-filters-sorting',\n    ButtonApply: 'jet-smart-filters-apply-button',\n    ButtonRemove: 'jet-smart-filters-remove-filters',\n    Pagination: 'jet-smart-filters-pagination',\n    ActiveFilters: 'jet-smart-filters-active',\n    ActiveTags: 'jet-smart-filters-active-tags'\n  },\n  filterClass: filterClass,\n  filters: filters__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  filterNames: [],\n  filterGroups: {},\n  initFilter: initFilter,\n  reinitFilters: reinitFilters,\n  findFilters: findFilters,\n  filtersUI: includes_filters_ui__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  setIndexedData: setIndexedData,\n  events: includes_event_bus__WEBPACK_IMPORTED_MODULE_3__[\"default\"]\n};\nvar additionalFiltersExceptions = ['ActiveFilters', 'ActiveTags', 'ButtonRemove'];\n\n//JetSmartFilters\nwindow.JetSmartFilters = JSF;\n\n// Init filters\n$(document).ready(function () {\n  // before initialization\n  var beforeInitEvent = new Event('jet-smart-filters/before-init');\n  document.dispatchEvent(beforeInitEvent);\n\n  // if elementor\n  if (window.elementorFrontend) {\n    // initialize elementor PRO widgets post rendered processing\n    includes_epro_compat__WEBPACK_IMPORTED_MODULE_4__[\"default\"].addSubscribers();\n  }\n  includes_preloader__WEBPACK_IMPORTED_MODULE_5__[\"default\"].init();\n\n  // initialization\n  // search and init filters\n  var $filters = JSF.findFilters();\n  $filters.each(function (index) {\n    var $filter = $filters.eq(index);\n    JSF.initFilter($filter);\n  });\n\n  // after initialization\n  var initedEvent = new Event('jet-smart-filters/inited');\n  document.dispatchEvent(initedEvent);\n});\n\n// Methods\nfunction initFilter($filter) {\n  if ($filter.is('[jsf-filter]')) return;\n\n  // mark the filter with an attribute that it has been initialized\n  $filter.attr('jsf-filter', '');\n  var filterName = null;\n  for (var key in JSF.filtersList) {\n    if ($filter.hasClass(JSF.filtersList[key])) filterName = key;\n  }\n  if (!filterName) return;\n  var filter = new JSF.filters[filterName]($filter);\n  if (filter.isHierarchy) {\n    filter.filters.forEach(function (hierarchyFilter) {\n      pushFilterToGroup(hierarchyFilter);\n    });\n  } else {\n    pushFilterToGroup(filter);\n  }\n\n  // Additional Filters\n  var additionalFilters = $filter.data('additional-providers') || $filter.find('[data-additional-providers]').data('additional-providers');\n  if (!additionalFilters || additionalFiltersExceptions.includes(filterName)) return;\n  additionalFilters.forEach(function (additionalFilter) {\n    var additionalFilterData = additionalFilter.split('/', 2),\n      additionalProvider = additionalFilterData[0],\n      additionalQueryId = additionalFilterData[1] || filter.queryId;\n    if (filter.isHierarchy) {\n      filter.filters.forEach(function (hierarchyFilter) {\n        pushFilterToGroup(createAdditionalFilter(additionalProvider, additionalQueryId, hierarchyFilter));\n      });\n    } else {\n      pushFilterToGroup(createAdditionalFilter(additionalProvider, additionalQueryId, filter));\n    }\n  });\n}\n;\nfunction reinitFilters() {\n  var filterNames = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n  if (filterNames && !Array.isArray(filterNames)) filterNames = [filterNames];\n  for (var groupKey in JSF.filterGroups) JSF.filterGroups[groupKey].reinitFilters(filterNames);\n}\nfunction pushFilterToGroup(filter) {\n  if (!filter.provider || !filter.queryId) return;\n  var provider = filter.provider;\n  var queryId = filter.queryId;\n  var filtersGroup = getFiltersGroup(provider, queryId);\n  filtersGroup.addFilter(filter);\n}\nfunction getFiltersGroup(provider, queryId) {\n  var groupKey = provider + '/' + queryId;\n  if (!JSF.filterGroups[groupKey]) JSF.filterGroups[groupKey] = new _FilterGroup__WEBPACK_IMPORTED_MODULE_0__[\"default\"](provider, queryId);\n  return JSF.filterGroups[groupKey];\n}\nfunction findFilters() {\n  var container = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $('html');\n  return $('.' + Object.values(JSF.filtersList).join(', .'), container);\n}\nfunction filterClass(filterName) {\n  for (var key in JSF.filtersList) if ('jet-smart-filters-' + filterName === JSF.filtersList[key]) return key;\n}\nfunction setIndexedData(provider) {\n  var query = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n  if (!JSF.filterGroups[provider] || !JSF.filterGroups[provider].indexingFilters) return;\n  var ajaxURL = (0,includes_utility__WEBPACK_IMPORTED_MODULE_6__.getNesting)(JetSmartFilterSettings, 'ajaxurl'),\n    requestData = {\n      action: 'jet_smart_filters_get_indexed_data',\n      provider: provider,\n      query_args: query,\n      indexing_filters: JSF.filterGroups[provider].indexingFilters\n    };\n  $.ajax({\n    url: ajaxURL,\n    type: 'POST',\n    dataType: 'json',\n    data: requestData\n  }).done(function (response) {\n    if (!response.data) return;\n    if (!window.JetSmartFilterSettings.jetFiltersIndexedData) window.JetSmartFilterSettings.jetFiltersIndexedData = {};\n    if (!window.JetSmartFilterSettings.jetFiltersIndexedData[provider]) window.JetSmartFilterSettings.jetFiltersIndexedData[provider] = {};\n\n    // update indexed data\n    window.JetSmartFilterSettings.jetFiltersIndexedData[provider] = response.data;\n    if (!JSF.filterGroups[provider]) return;\n    JSF.filterGroups[provider].filters.forEach(function (filter) {\n      if (!filter.indexer) return;\n      filter.indexer.update();\n    });\n  });\n}\nfunction createAdditionalFilter(additionalProvider, additionalQueryId, filter) {\n  var filterData = {\n    isAdditional: true,\n    name: filter.name,\n    path: filter.path,\n    provider: additionalProvider,\n    queryId: additionalQueryId,\n    filterId: filter.filterId,\n    queryKey: filter.queryKey,\n    data: filter.data,\n    reset: function reset() {\n      this.data = false;\n    }\n  };\n  if (filter.isHierarchy) {\n    filterData.isHierarchy = true;\n    filterData.depth = filter.depth;\n  }\n  return filterData;\n}\n\n// filling array with names\nfor (var key in JSF.filtersList) {\n  var filter = JSF.filtersList[key];\n  JSF.filterNames.push(filter.replace('jet-smart-filters-', ''));\n}\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSF);\n\n//# sourceURL=webpack:///./js/filters-initializer.js?")}),"./js/filters/ActiveFilters.js":
/*!*************************************!*\
  !*** ./js/filters/ActiveFilters.js ***!
  \*************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ActiveFilters)\n/* harmony export */ });\n/* harmony import */ var bases_ActiveItems__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/ActiveItems */ \"./js/bases/ActiveItems.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar ActiveFilters = /*#__PURE__*/function (_ActiveItems) {\n  _inherits(ActiveFilters, _ActiveItems);\n  var _super = _createSuper(ActiveFilters);\n  function ActiveFilters($activeFilters) {\n    var _this;\n    _classCallCheck(this, ActiveFilters);\n    var props = {\n      templateName: 'active_filter',\n      listClass: 'jet-active-filters__list',\n      labelClass: 'jet-active-filters__title',\n      itemClass: 'jet-active-filter'\n    };\n    _this = _super.call(this, $activeFilters, props);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'active-filters');\n    return _this;\n  }\n  return _createClass(ActiveFilters);\n}(bases_ActiveItems__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/ActiveFilters.js?")}),"./js/filters/ActiveTags.js":
/*!**********************************!*\
  !*** ./js/filters/ActiveTags.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ActiveTags)\n/* harmony export */ });\n/* harmony import */ var bases_ActiveItems__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/ActiveItems */ \"./js/bases/ActiveItems.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar ActiveTags = /*#__PURE__*/function (_ActiveItems) {\n  _inherits(ActiveTags, _ActiveItems);\n  var _super = _createSuper(ActiveTags);\n  function ActiveTags($activeTags) {\n    var _this;\n    _classCallCheck(this, ActiveTags);\n    var props = {\n      separateMultiple: true,\n      templateName: 'active_tag',\n      listClass: 'jet-active-tags__list',\n      labelClass: 'jet-active-tags__title',\n      itemClass: 'jet-active-tag',\n      clearClass: 'jet-active-tag jet-active-tag--clear'\n    };\n    _this = _super.call(this, $activeTags, props);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'active-tags');\n    return _this;\n  }\n  return _createClass(ActiveTags);\n}(bases_ActiveItems__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/ActiveTags.js?")}),"./js/filters/Alphabet.js":
/*!********************************!*\
  !*** ./js/filters/Alphabet.js ***!
  \********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Alphabet)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Checkbox */ \"./js/bases/controls/Checkbox.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Alphabet = /*#__PURE__*/function (_CheckboxControl) {\n  _inherits(Alphabet, _CheckboxControl);\n  var _super = _createSuper(Alphabet);\n  function Alphabet($container) {\n    var _this;\n    _classCallCheck(this, Alphabet);\n    var $filter = $container.find('.jet-alphabet-list');\n    _this = _super.call(this, $container, $filter, $filter.find('.jet-alphabet-list__input'));\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'alphabet');\n    return _this;\n  }\n  return _createClass(Alphabet);\n}(bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Alphabet.js?")}),"./js/filters/ButtonApply.js":
/*!***********************************!*\
  !*** ./js/filters/ButtonApply.js ***!
  \***********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ButtonApply)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar ButtonApply = /*#__PURE__*/function (_Filter) {\n  _inherits(ButtonApply, _Filter);\n  var _super = _createSuper(ButtonApply);\n  function ButtonApply($container) {\n    var _this;\n    _classCallCheck(this, ButtonApply);\n    var $filter = $container.find('.apply-filters');\n    _this = _super.call(this, $filter, $container);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'button-apply');\n    _this.$filter.find('.apply-filters__button').on('click', function () {\n      _this.emitFitersApply();\n    });\n    return _this;\n  }\n  return _createClass(ButtonApply);\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/ButtonApply.js?")}),"./js/filters/ButtonRemove.js":
/*!************************************!*\
  !*** ./js/filters/ButtonRemove.js ***!
  \************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ButtonRemove)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar ButtonRemove = /*#__PURE__*/function (_Filter) {\n  _inherits(ButtonRemove, _Filter);\n  var _super = _createSuper(ButtonRemove);\n  function ButtonRemove($container) {\n    var _this;\n    _classCallCheck(this, ButtonRemove);\n    var $filter = $container.find('.jet-remove-all-filters__button');\n    _this = _super.call(this, $filter, $container.find('.jet-remove-all-filters'));\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'button-remove');\n    _this.$elementorWidget = _this.$container.closest('.hide-widget');\n    _this.$filter.on('click', function () {\n      _this.emitFitersRemove();\n    });\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('activeItems/change', function (activeItems, provider, queryId) {\n      if (!_this.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      }) && !_this.isAdditionalProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      if (activeItems.length) {\n        _this.show();\n        _this.$elementorWidget.removeClass('hide-widget');\n      } else {\n        _this.hide();\n        _this.$elementorWidget.addClass('hide-widget');\n      }\n    });\n    return _this;\n  }\n  return _createClass(ButtonRemove);\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/ButtonRemove.js?")}),"./js/filters/CheckBoxes.js":
/*!**********************************!*\
  !*** ./js/filters/CheckBoxes.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ CheckBoxes)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Checkbox */ \"./js/bases/controls/Checkbox.js\");\n/* harmony import */ var modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! modules/AdditionalFilterSettings */ \"./js/modules/AdditionalFilterSettings.js\");\n/* harmony import */ var modules_ollapsibleList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! modules/СollapsibleList */ \"./js/modules/СollapsibleList.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nvar CheckBoxes = /*#__PURE__*/function (_CheckboxControl) {\n  _inherits(CheckBoxes, _CheckboxControl);\n  var _super = _createSuper(CheckBoxes);\n  function CheckBoxes($container) {\n    var _this;\n    _classCallCheck(this, CheckBoxes);\n    var $filter = $container.find('.jet-checkboxes-list');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'checkboxes');\n    _this.mergeSameQueryKeys = true;\n\n    // Init modules\n    _this.additionalFilterSettings = new modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__[\"default\"](_assertThisInitialized(_this));\n    _this.collapsibleList = new modules_ollapsibleList__WEBPACK_IMPORTED_MODULE_2__[\"default\"](_assertThisInitialized(_this));\n    return _this;\n  }\n  return _createClass(CheckBoxes);\n}(bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/CheckBoxes.js?")}),"./js/filters/CheckRange.js":
/*!**********************************!*\
  !*** ./js/filters/CheckRange.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ CheckRange)\n/* harmony export */ });\n/* harmony import */ var _CheckBoxes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CheckBoxes */ \"./js/filters/CheckBoxes.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar CheckRange = /*#__PURE__*/function (_CheckBoxesFilter) {\n  _inherits(CheckRange, _CheckBoxesFilter);\n  var _super = _createSuper(CheckRange);\n  function CheckRange($container) {\n    var _this;\n    _classCallCheck(this, CheckRange);\n    _this = _super.call(this, $container);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'check-range');\n    _this.mergeSameQueryKeys = false;\n    return _this;\n  }\n  return _createClass(CheckRange);\n}(_CheckBoxes__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/CheckRange.js?")}),"./js/filters/DatePeriod.js":
/*!**********************************!*\
  !*** ./js/filters/DatePeriod.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ DatePeriod)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar DatePeriod = /*#__PURE__*/function (_Filter) {\n  _inherits(DatePeriod, _Filter);\n  var _super = _createSuper(DatePeriod);\n  function DatePeriod($container) {\n    var _this;\n    _classCallCheck(this, DatePeriod);\n    var $filter = $container.find('.jet-date-period');\n    _this = _super.call(this, $filter, $container);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'date-period');\n    _defineProperty(_assertThisInitialized(_this), \"datepickerButtonSelector\", '.jet-date-period__datepicker-button');\n    _defineProperty(_assertThisInitialized(_this), \"datepickerInputSelector\", '.jet-date-period__datepicker-input');\n    _defineProperty(_assertThisInitialized(_this), \"prevPeriodButtonSelector\", '.jet-date-period__prev');\n    _defineProperty(_assertThisInitialized(_this), \"nextPeriodButtonSelector\", '.jet-date-period__next');\n    _defineProperty(_assertThisInitialized(_this), \"datepickerOpenedClass\", 'jet-date-period-datepicker-opened');\n    _defineProperty(_assertThisInitialized(_this), \"periodIsSetClass\", 'jet-date-period-is-set');\n    _defineProperty(_assertThisInitialized(_this), \"periodStartClass\", 'jet-date-period-start');\n    _defineProperty(_assertThisInitialized(_this), \"periodSeparatorClass\", 'jet-date-period-separator');\n    _defineProperty(_assertThisInitialized(_this), \"periodEndClass\", 'jet-date-period-end');\n    _this.datePeriod = [];\n    _this.id = _this.$filter.closest('.elementor-widget-jet-smart-filters-date-period').data('id') || _this.$filter.closest('.brxe-jet-smart-filters-date-period').attr('id');\n    _this.$datepickerBtn = $filter.find(_this.datepickerButtonSelector);\n    _this.$prevPeriodBtn = $filter.find(_this.prevPeriodButtonSelector);\n    _this.$nextPeriodBtn = $filter.find(_this.nextPeriodButtonSelector);\n    _this.$datepickerInput = $filter.find(_this.datepickerInputSelector);\n    _this.dateFormat = _this.$datepickerInput.data('format');\n    _this.minDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.parseDateExpression)(_this.$datepickerInput.data('mindate'));\n    _this.maxDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.parseDateExpression)(_this.$datepickerInput.data('maxdate'));\n    _this.startEndDateEnabled = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.isObject)(_this.dateFormat) ? true : false;\n    _this.dateSeparator = _this.startEndDateEnabled && _this.dateFormat.separator ? ' ' + _this.dateFormat.separator + ' ' : ' - ';\n    _this.periodType = _this.$filter.data('period-type') || 'day';\n    _this.btnPlaceholder = _this.$datepickerBtn.html();\n    _this.$datepickerInput.prop('type', 'text');\n    _this.debounceInitDatepickerWeekHover = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.debounce)(_this.initDatepickerWeekHover, 100);\n    _this.initDatepicker();\n    _this.initEvent();\n    _this.processData();\n    return _this;\n  }\n  _createClass(DatePeriod, [{\n    key: \"initDatepicker\",\n    value: function initDatepicker() {\n      var _this2 = this;\n      var datepickerOptions = {\n        language: 'jsf',\n        dateFormat: 'yy/m/d',\n        autoClose: true,\n        position: 'bottom left',\n        offset: 0,\n        view: 'days',\n        minView: 'days',\n        firstDay: Number((0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(JetSmartFilterSettings, 'misc', 'week_start'))\n      };\n\n      // min max date enabled\n      if (this.minDate) datepickerOptions.minDate = this.minDate;\n      if (this.maxDate) datepickerOptions.maxDate = this.maxDate;\n\n      // add localization\n      if (!$.fn.airDatepicker.language['jsf']) {\n        var localizedText = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(JetSmartFilterSettings, 'datePickerData');\n        $.fn.airDatepicker.language['jsf'] = {\n          days: localizedText.dayNames,\n          daysShort: localizedText.dayNamesShort,\n          daysMin: localizedText.dayNamesMin,\n          months: localizedText.monthNames,\n          monthsShort: localizedText.monthNamesShort,\n          today: localizedText.currentText,\n          clear: localizedText.closeText\n        };\n      }\n\n      // datepicker on select\n      datepickerOptions.onSelect = function (formattedDate, date, inst) {\n        if (!date) return;\n        var startDate = date,\n          endDate;\n        switch (_this2.periodType) {\n          case 'week':\n            var dayOffset = inst.opts.firstDay > date.getDay() ? inst.opts.firstDay - 7 : inst.opts.firstDay;\n            startDate = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay() + dayOffset);\n            endDate = new Date(date.getFullYear(), date.getMonth(), date.getDate() - date.getDay() + 6 + dayOffset);\n            break;\n          case 'month':\n            endDate = new Date(date.getFullYear(), date.getMonth() + 1, 0);\n            break;\n          case 'year':\n            endDate = new Date(date.getFullYear(), 11, 31);\n            break;\n          case 'range':\n            if (!Array.isArray(date) || date.length < 2) return;\n            startDate = date[0];\n            endDate = date[1];\n            if ((!_this2.minDate || _this2.minDate < startDate) && (!_this2.maxDate || _this2.maxDate > endDate)) _this2.periodCustomRange = Math.round(Math.abs((endDate - startDate) / (24 * 60 * 60 * 1000)));\n            break;\n          default:\n            _this2.$datepickerInput.val((0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.convertDate)(date)).trigger('change');\n            return;\n        }\n        if (_this2.minDate && _this2.minDate > startDate) startDate = _this2.minDate;\n        if (_this2.maxDate && _this2.maxDate < endDate) endDate = _this2.maxDate;\n        _this2.$datepickerInput.val((0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.convertDate)(startDate) + '-' + (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.convertDate)(endDate)).trigger('change');\n      };\n\n      // datepicker on show\n      datepickerOptions.onShow = function (inst) {\n        if (_this2.id) inst.$datepicker.addClass('jet-date-period-' + _this2.id);\n        _this2.$filter.addClass(_this2.datepickerOpenedClass);\n        inst.$datepicker.addClass('jet-date-period-' + _this2.periodType);\n      };\n\n      // datepicker on hide\n      datepickerOptions.onHide = function (inst) {\n        if (_this2.id) inst.$datepicker.removeClass('jet-date-period-' + _this2.id);\n        _this2.$filter.removeClass(_this2.datepickerOpenedClass);\n        inst.$datepicker.removeClass('jet-date-period-' + _this2.periodType);\n      };\n\n      // datepicker on render cell\n      datepickerOptions.onRenderCell = function (date, cellType) {\n        // set active week period and add week hover\n        if (_this2.periodType === 'week' && cellType === 'day') {\n          _this2.debounceInitDatepickerWeekHover();\n          if (_this2.isDateInRange(date)) {\n            var classes = '-week-selected-';\n            if (_this2.isDateFirstInRange(date)) classes += ' -week-start-selected-';\n            if (_this2.isDateLastInRange(date)) classes += ' -week-end-selected-';\n            return {\n              classes: classes\n            };\n          }\n        }\n      };\n      if (this.periodType === 'month') {\n        datepickerOptions.view = 'months';\n        datepickerOptions.minView = 'months';\n      }\n      if (this.periodType === 'year') {\n        datepickerOptions.view = 'years';\n        datepickerOptions.minView = 'years';\n      }\n      if (this.periodType === 'range') datepickerOptions.range = true;\n\n      /* if (this.isRTL)\n      \tdatepickerOptions.position = 'bottom right'; */\n\n      // init air datepicker\n      this.$datepicker = this.$datepickerInput.airDatepicker(datepickerOptions);\n      this.datepicker = this.$datepicker.data('datepicker');\n\n      // clear events to avoid duplication\n      this.$datepickerBtn.off('click');\n      this.$prevPeriodBtn.off('click');\n      this.$nextPeriodBtn.off('click');\n      this.$nextPeriodBtn.off('click');\n      this.$datepickerInput.off('change');\n\n      // init events\n      this.$datepickerBtn.on('click', function () {\n        _this2.datepicker.show();\n      });\n      this.$prevPeriodBtn.on('click', function () {\n        _this2.prevPeriod();\n      });\n      this.$nextPeriodBtn.on('click', function () {\n        _this2.nextPeriod();\n      });\n      this.$datepickerInput.on('change', function () {\n        _this2.processData();\n      });\n    }\n  }, {\n    key: \"addFilterChangeEvent\",\n    value: function addFilterChangeEvent() {\n      var _this3 = this;\n      this.$prevPeriodBtn.on('click', function () {\n        _this3.wasСhanged();\n      });\n      this.$nextPeriodBtn.on('click', function () {\n        _this3.wasСhanged();\n      });\n      this.$datepickerInput.on('change', function () {\n        _this3.wasСhanged();\n      });\n    }\n  }, {\n    key: \"removeChangeEvent\",\n    value: function removeChangeEvent() {\n      this.$datepickerBtn.off();\n      this.$prevPeriodBtn.off();\n      this.$nextPeriodBtn.off();\n      this.$datepickerInput.off();\n    }\n  }, {\n    key: \"processData\",\n    value: function processData() {\n      this.setPeriod();\n      this.dataValue = this.$datepickerInput.val() || false;\n    }\n  }, {\n    key: \"setData\",\n    value: function setData(newData) {\n      if (!newData) {\n        this.reset();\n        return;\n      }\n      this.$datepickerInput.val(newData);\n      this.processData();\n      if (!this.datePeriod.length) return;\n      var newDate = this.periodType === 'range' && this.datePeriod.length === 2 ? [this.datePeriod[0].date, this.datePeriod[1].date] : this.datePeriod[0].date;\n      this.datepicker.selectDate(newDate);\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.$datepickerInput.val('');\n      this.processData();\n      this.datepicker.clear();\n      this.datepicker.date = new Date();\n    }\n  }, {\n    key: \"activeValue\",\n    get: function get() {\n      var periodStartDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(this.datePeriod, '0', 'date'),\n        periodStartFormatted = periodStartDate ? this.getFormattedDate(periodStartDate, 'start') : false,\n        periodEndDate = this.startEndDateEnabled ? (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(this.datePeriod, '1', 'date') : false,\n        periodEndFormatted = periodEndDate ? this.getFormattedDate(periodEndDate, 'end') : false;\n      if (periodStartFormatted && periodEndFormatted) {\n        return periodStartFormatted + this.dateSeparator + periodEndFormatted;\n      } else {\n        return periodStartFormatted;\n      }\n    }\n  }, {\n    key: \"setPeriod\",\n    value: function setPeriod() {\n      var _this4 = this;\n      var inputValue = this.$datepickerInput.val(),\n        datesArray = [];\n      if (inputValue) inputValue.split('-', 2).forEach(function (dateValue) {\n        datesArray.push(dateValue);\n      });\n      this.datePeriod = [];\n      datesArray.forEach(function (dateValue) {\n        var date = new Date(dateValue.replaceAll('.', '/'));\n        if (!(date instanceof Date)) return;\n        _this4.datePeriod.push({\n          date: date,\n          value: dateValue\n        });\n      });\n      this.renderPeriod();\n    }\n  }, {\n    key: \"prevPeriod\",\n    value: function prevPeriod() {\n      var periodStart = this.datePeriod[0] || false;\n      if (!periodStart || this.minDate && this.minDate >= periodStart.date) return;\n      var newPeriodEnd = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(periodStart.date, -1);\n      var newPeriodStart = newPeriodEnd;\n      if (this.periodType === 'week') {\n        newPeriodStart = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(newPeriodEnd, -6);\n      } else if (this.periodType === 'month') {\n        newPeriodStart = new Date(newPeriodEnd.getFullYear(), newPeriodEnd.getMonth(), 1);\n      } else if (this.periodType === 'year') {\n        newPeriodStart = new Date(newPeriodEnd.getFullYear(), 0, 1);\n      } else if (this.periodType === 'range') {\n        newPeriodStart = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(new Date(newPeriodEnd.getTime()), -this.periodCustomRange);\n      }\n      if (this.minDate && newPeriodStart < this.minDate) newPeriodStart = this.minDate;\n      this.datepicker.selectDate(this.periodType === 'range' ? [newPeriodStart, newPeriodEnd] : newPeriodStart);\n    }\n  }, {\n    key: \"nextPeriod\",\n    value: function nextPeriod() {\n      var periodEnd = this.datePeriod[1] || this.datePeriod[0] || false;\n      if (!periodEnd || this.maxDate && this.maxDate <= periodEnd.date) return;\n      var newPeriodStart = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(periodEnd.date);\n      var newPeriodEnd = newPeriodStart;\n      if (this.periodType === 'week') {\n        newPeriodEnd = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(new Date(newPeriodStart.getTime()), 6);\n      } else if (this.periodType === 'month') {\n        newPeriodEnd = new Date(newPeriodStart.getFullYear(), newPeriodStart.getMonth() + 1, 0);\n      } else if (this.periodType === 'year') {\n        newPeriodEnd = new Date(newPeriodStart.getFullYear(), 11, 31);\n      } else if (this.periodType === 'range') {\n        newPeriodEnd = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.dateAddDay)(new Date(newPeriodStart.getTime()), this.periodCustomRange);\n      }\n      if (this.maxDate && newPeriodEnd > this.maxDate) newPeriodEnd = this.maxDate;\n      this.datepicker.selectDate(this.periodType === 'range' ? [newPeriodStart, newPeriodEnd] : newPeriodStart);\n    }\n  }, {\n    key: \"renderPeriod\",\n    value: function renderPeriod() {\n      if (!this.datePeriod.length) {\n        this.$filter.removeClass(this.periodIsSetClass);\n        this.$datepickerBtn.html(this.btnPlaceholder);\n        return;\n      }\n      var periodStartDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(this.datePeriod, '0', 'date'),\n        periodStartHtml = periodStartDate ? \"<div class=\\\"\".concat(this.periodStartClass, \"\\\">\").concat(this.getFormattedDate(periodStartDate, 'start'), \"</div>\") : '',\n        periodEndDate = this.startEndDateEnabled ? (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(this.datePeriod, '1', 'date') : false,\n        periodEndHtml = periodEndDate ? \"<div class=\\\"\".concat(this.periodEndClass, \"\\\">\").concat(this.getFormattedDate(periodEndDate, 'end'), \"</div>\") : '',\n        periodSeparatorHtml = periodStartDate && periodEndDate ? \"<div class=\\\"\".concat(this.periodSeparatorClass, \"\\\">\").concat(this.dateSeparator, \"</div>\") : '';\n      this.$filter.addClass(this.periodIsSetClass);\n      this.$datepickerBtn.html(periodStartHtml + periodSeparatorHtml + periodEndHtml);\n    }\n  }, {\n    key: \"getFormattedDate\",\n    value: function getFormattedDate(date) {\n      var position = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n      var format = 'mm/dd/yy';\n      if (this.dateFormat) {\n        if (this.startEndDateEnabled) {\n          if ((position === 'start' || !position) && this.dateFormat.start) format = this.dateFormat.start;\n          if (position === 'end' && this.dateFormat.end) format = this.dateFormat.end;\n        } else {\n          format = this.dateFormat;\n        }\n      }\n      return this.datepicker.formatDate(format, date);\n    }\n  }, {\n    key: \"isDateInRange\",\n    value: function isDateInRange(date) {\n      if (!(date instanceof Date) || this.datePeriod.length < 2) return false;\n      var datestamp = date.getTime(),\n        startDatestamp = this.datePeriod[0].date.getTime(),\n        endDatestamp = this.datePeriod[1].date.getTime();\n      return datestamp >= startDatestamp && datestamp <= endDatestamp ? true : false;\n    }\n  }, {\n    key: \"isDateFirstInRange\",\n    value: function isDateFirstInRange(date) {\n      if (!(date instanceof Date) || !this.datePeriod[0]) return false;\n      var datestamp = date.getTime(),\n        startDatestamp = this.datePeriod[0].date.getTime();\n      return datestamp === startDatestamp ? true : false;\n    }\n  }, {\n    key: \"isDateLastInRange\",\n    value: function isDateLastInRange(date) {\n      if (!(date instanceof Date) || !this.datePeriod[1]) return false;\n      var datestamp = date.getTime(),\n        endDatestamp = this.datePeriod[1].date.getTime();\n      return datestamp === endDatestamp ? true : false;\n    }\n  }, {\n    key: \"initDatepickerWeekHover\",\n    value: function initDatepickerWeekHover() {\n      var $days = this.datepicker.$content.find('.datepicker--cells-days .datepicker--cell-day');\n      var weekHoveredDays = [];\n      $days.off().on({\n        mouseenter: function mouseenter(evt) {\n          var dayNumber = _toConsumableArray(evt.target.parentNode.children).indexOf(evt.target);\n          if (dayNumber < 0) return;\n          for (var index = 0; index < 7; index++) {\n            var $day = $days.eq(index + Math.floor(dayNumber / 7) * 7);\n            $day.addClass('-week-hover-');\n            if (index === 0) $day.addClass('-week-start-hover-');\n            if (index === 6) $day.addClass('-week-end-hover-');\n            weekHoveredDays.push($day);\n          }\n        },\n        mouseleave: function mouseleave(evt) {\n          weekHoveredDays.forEach(function ($day) {\n            $day.removeClass('-week-hover- -week-start-hover- -week-end-hover-');\n          });\n          weekHoveredDays = [];\n        }\n      });\n    }\n  }]);\n  return DatePeriod;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/DatePeriod.js?")}),"./js/filters/DateRange.js":
/*!*********************************!*\
  !*** ./js/filters/DateRange.js ***!
  \*********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ DateRange)\n/* harmony export */ });\n/* harmony import */ var bases_controls_DateRange__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/DateRange */ \"./js/bases/controls/DateRange.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar DateRange = /*#__PURE__*/function (_DateRangeControl) {\n  _inherits(DateRange, _DateRangeControl);\n  var _super = _createSuper(DateRange);\n  function DateRange($container) {\n    var _this;\n    _classCallCheck(this, DateRange);\n    var $filter = $container.find('.jet-date-range');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'date-range');\n    return _this;\n  }\n  return _createClass(DateRange);\n}(bases_controls_DateRange__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/DateRange.js?")}),"./js/filters/Pagination.js":
/*!**********************************!*\
  !*** ./js/filters/Pagination.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Pagination)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_preloader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! includes/preloader */ \"./js/includes/preloader.js\");\n/* harmony import */ var includes_template_parser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! includes/template-parser */ \"./js/includes/template-parser.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\n\n\nvar Pagination = /*#__PURE__*/function (_Filter) {\n  _inherits(Pagination, _Filter);\n  var _super = _createSuper(Pagination);\n  function Pagination($filter) {\n    var _this;\n    _classCallCheck(this, Pagination);\n    _this = _super.call(this, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'pagination');\n    _defineProperty(_assertThisInitialized(_this), \"paginationListClass\", 'jet-filters-pagination');\n    _defineProperty(_assertThisInitialized(_this), \"paginationItemClass\", 'jet-filters-pagination__item');\n    _defineProperty(_assertThisInitialized(_this), \"paginationLoadMoreClass\", 'jet-filters-pagination__load-more');\n    _defineProperty(_assertThisInitialized(_this), \"paginationCurrentClass\", 'jet-filters-pagination__current');\n    _defineProperty(_assertThisInitialized(_this), \"paginationDisabledClass\", 'jet-filters-pagination__disabled');\n    _defineProperty(_assertThisInitialized(_this), \"navClass\", 'prev-next');\n    _defineProperty(_assertThisInitialized(_this), \"prevClass\", 'prev');\n    _defineProperty(_assertThisInitialized(_this), \"nextClass\", 'next');\n    _this.pageIndex = _this.pageProp;\n    _this.dataValue = _this.pageIndex;\n    _this.pagesCount = _this.maxNumPagesProp;\n    _this.controls = _this.$filter.data('controls');\n    _this.isItems = _this.controls.items_enabled || false;\n    _this.midSize = _this.controls.pages_mid_size || 0;\n    _this.endSize = _this.controls.pages_end_size || 0;\n    _this.isNav = _this.controls.nav_enabled || false;\n    _this.hideInactiveNav = _this.controls.hide_inactive_nav || false;\n    _this.prevText = _this.controls.prev;\n    _this.nextText = _this.controls.next;\n    _this.isLoadMore = _this.controls.load_more_enabled || false;\n    _this.loadMoreText = _this.controls.load_more_text;\n    _this.moreActiveIndexes = [];\n    _this.templates = (0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'templates', 'pagination') || {};\n    if (undefined !== _this.controls.provider_top_offset) _this.topOffset = _this.controls.provider_top_offset || 0;\n    _this.buildPagination();\n\n    // Event subscriptions\n    includes_preloader__WEBPACK_IMPORTED_MODULE_2__[\"default\"].subscribe($filter, {\n      provider: _this.provider,\n      queryId: _this.queryId\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('ajaxFilters/end-loading', function (provider, queryId) {\n      if (!_this.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      _this.update();\n    });\n    // Change data value for duplicate pagination filters\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('pagination/change', function (paginationFilter) {\n      if (!_this.isCurrentProvider(paginationFilter)) return;\n      if (paginationFilter.data !== _this.data) _this.dataValue = paginationFilter.data;\n    });\n    return _this;\n  }\n  _createClass(Pagination, [{\n    key: \"reinit\",\n    value: function reinit() {\n      this.update();\n    }\n  }, {\n    key: \"buildPagination\",\n    value: function buildPagination() {\n      if (this.pagesCount < 2) {\n        this.$filter.html('');\n        return;\n      }\n\n      // remove all jQuery events to avoid memory leak\n      this.$filter.find('*').off('click');\n      var elList = document.createElement('div');\n      elList.className = this.paginationListClass;\n      var isPrevItemDots = false;\n      if (this.isItems) {\n        for (var i = 1; i <= this.pagesCount; i++) {\n          var showDots = this.midSize !== 0 ? this.endSize < i && i < this.pageIndex - this.midSize || this.endSize <= this.pagesCount - i && i > this.pageIndex + this.midSize : false;\n          if (showDots) {\n            if (!isPrevItemDots) {\n              elList.appendChild(this.buildDotsItem());\n              isPrevItemDots = true;\n            }\n          } else {\n            elList.appendChild(this.buildPaginationItem('numeral', i, this.onPaginationItemClick.bind(this)));\n            isPrevItemDots = false;\n          }\n        }\n      }\n      if (this.isNav) {\n        var isFirstPage = this.pageIndex === 1 || this.moreActiveIndexes.includes(1);\n        var isLastPage = this.pageIndex === this.pagesCount;\n        if (!this.hideInactiveNav || !isFirstPage) {\n          var prevEl = this.buildPaginationItem('prev', this.prevText, this.onPaginationItemClick.bind(this));\n          if (isFirstPage) prevEl.setAttribute('disabled', '');\n          elList.prepend(prevEl);\n        }\n        if (!this.hideInactiveNav || !isLastPage) {\n          var nextEl = this.buildPaginationItem('next', this.nextText, this.onPaginationItemClick.bind(this));\n          if (isLastPage) nextEl.setAttribute('disabled', '');\n          elList.append(nextEl);\n        }\n      }\n      if (this.isLoadMore && this.pageIndex < this.pagesCount) {\n        elList.appendChild(this.buildLoadMore());\n      }\n      this.$filter.html(elList);\n      this.setCurrentItem();\n\n      // Emit pagination items build event\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('pagination/itemsBuilt', this);\n    }\n  }, {\n    key: \"buildPaginationItem\",\n    value: function buildPaginationItem(type, value, clickCallBack) {\n      var itemContent = '';\n      if (this.templates.item) {\n        itemContent = includes_template_parser__WEBPACK_IMPORTED_MODULE_3__[\"default\"].replaceWithValue(this.templates.item, value);\n      } else {\n        itemContent = value;\n      }\n      var elPaginationItem = document.createElement('div');\n      elPaginationItem.className = this.paginationItemClass;\n      elPaginationItem.innerHTML = itemContent;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'use_tabindex') === 'true') elPaginationItem.tabIndex = 0;\n      if (type === 'prev' || type === 'next') {\n        elPaginationItem.dataset.value = type;\n        elPaginationItem.classList.add(this.navClass);\n        elPaginationItem.classList.add(this[type + 'Class']);\n      } else {\n        elPaginationItem.dataset.value = value;\n      }\n\n      // add jQuery click event\n      $(elPaginationItem).on('click', clickCallBack);\n      return elPaginationItem;\n    }\n  }, {\n    key: \"buildDotsItem\",\n    value: function buildDotsItem() {\n      var elDotsItem = document.createElement('div');\n      var dotsContent = '';\n      if (this.templates.dots) {\n        dotsContent = this.templates.dots;\n      } else {\n        dotsContent = '...';\n      }\n      elDotsItem.className = this.paginationItemClass;\n      elDotsItem.innerHTML = dotsContent;\n      return elDotsItem;\n    }\n  }, {\n    key: \"buildLoadMore\",\n    value: function buildLoadMore() {\n      var elLoadMore = document.createElement('div');\n      var loadMoreContent = '';\n      if (this.templates.load_more) {\n        loadMoreContent = includes_template_parser__WEBPACK_IMPORTED_MODULE_3__[\"default\"].replaceWithValue(this.templates.load_more, this.loadMoreText);\n      } else {\n        loadMoreContent = this.loadMoreText;\n      }\n      elLoadMore.className = this.paginationLoadMoreClass;\n      elLoadMore.innerHTML = loadMoreContent;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'use_tabindex') === 'true') elLoadMore.tabIndex = 0;\n      $(elLoadMore).on('click', this.onPaginationLoadMoreClick.bind(this));\n      return elLoadMore;\n    }\n  }, {\n    key: \"onPaginationItemClick\",\n    value: function onPaginationItemClick(evt) {\n      if (this.isAjaxLoading) return;\n      var $item = $(evt.currentTarget);\n      var value = $item.data('value');\n      switch (value) {\n        case 'prev':\n          var pageIndex = this.moreActiveIndexes[0] || this.pageIndex;\n          if (pageIndex > 1) {\n            value = pageIndex - 1;\n          } else {\n            value = 1;\n          }\n          break;\n        case 'next':\n          if (this.pageIndex < this.pagesCount) {\n            value = this.pageIndex + 1;\n          } else {\n            value = this.pagesCount;\n          }\n          break;\n      }\n      if (this.pageIndex !== value && !this.moreActiveIndexes.includes(value)) {\n        this.moreActiveIndexes = [];\n        this.dataValue = value;\n        this.updateActivePagesProviderProps();\n\n        // emit pagination change\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('pagination/change', this);\n      }\n    }\n  }, {\n    key: \"onPaginationLoadMoreClick\",\n    value: function onPaginationLoadMoreClick(evt) {\n      if (this.isAjaxLoading) return;\n      var value = this.dataValue;\n      value++;\n      if (value <= this.pagesCount) {\n        this.moreActiveIndexes.push(this.dataValue);\n        this.dataValue = value;\n        this.updateActivePagesProviderProps();\n\n        // emit pagination load more\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('pagination/load-more', this);\n      }\n    }\n  }, {\n    key: \"updateActivePagesProviderProps\",\n    value: function updateActivePagesProviderProps() {\n      if (!(0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'props', this.provider, this.queryId)) return;\n      var providerProps = window.JetSmartFilterSettings.props[this.provider][this.queryId];\n      if (this.moreActiveIndexes.length) {\n        providerProps.pages = [].concat(_toConsumableArray(this.moreActiveIndexes), [this.dataValue]);\n      } else {\n        delete providerProps.pages;\n      }\n    }\n  }, {\n    key: \"setCurrentItem\",\n    value: function setCurrentItem() {\n      if (!this.pageIndex) return;\n      var $container = this.$filter.find('.' + this.paginationListClass);\n      var activeItemsSelector = [this.pageIndex].concat(_toConsumableArray(this.moreActiveIndexes)).map(function (item) {\n        return \"[data-value='\" + item + \"']\";\n      }).join(', ');\n      $container.children().removeClass(this.paginationCurrentClass);\n      $container.find(activeItemsSelector).addClass(this.paginationCurrentClass);\n    }\n  }, {\n    key: \"update\",\n    value: function update() {\n      var currentPagesCount = this.maxNumPagesProp;\n      var currentDataValue = this.pageProp;\n      if (currentPagesCount === this.pagesCount && currentDataValue === this.pageIndex) return;\n      this.pagesCount = currentPagesCount;\n      this.pageIndex = currentDataValue;\n      this.dataValue = this.pageIndex;\n      this.buildPagination();\n    }\n  }, {\n    key: \"reset\",\n    value: function reset() {\n      this.moreActiveIndexes = [];\n      this.dataValue = 1;\n      this.updateActivePagesProviderProps();\n    }\n  }, {\n    key: \"resetMoreActive\",\n    value: function resetMoreActive() {\n      if (!this.moreActiveIndexes.length) return;\n      this.moreActiveIndexes = [];\n      this.updateActivePagesProviderProps();\n      this.buildPagination();\n    }\n\n    // Getters\n  }, {\n    key: \"data\",\n    get: function get() {\n      return this.dataValue && this.dataValue > 1 ? this.dataValue : false;\n    }\n  }, {\n    key: \"pageProp\",\n    get: function get() {\n      var page = Number((0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'props', this.provider, this.queryId, 'page'));\n      return page || 1;\n    }\n  }, {\n    key: \"maxNumPagesProp\",\n    get: function get() {\n      var maxNumPages = Number((0,includes_utility__WEBPACK_IMPORTED_MODULE_4__.getNesting)(JetSmartFilterSettings, 'props', this.provider, this.queryId, 'max_num_pages'));\n      return maxNumPages || 0;\n    }\n  }, {\n    key: \"queryKey\",\n    get: function get() {\n      return 'jet_paged';\n    }\n  }]);\n  return Pagination;\n}(bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Pagination.js?")}),"./js/filters/Radio.js":
/*!*****************************!*\
  !*** ./js/filters/Radio.js ***!
  \*****************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Radio)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Select */ \"./js/bases/controls/Select.js\");\n/* harmony import */ var modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! modules/AdditionalFilterSettings */ \"./js/modules/AdditionalFilterSettings.js\");\n/* harmony import */ var modules_ollapsibleList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! modules/СollapsibleList */ \"./js/modules/СollapsibleList.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\n\nvar Radio = /*#__PURE__*/function (_SelectControl) {\n  _inherits(Radio, _SelectControl);\n  var _super = _createSuper(Radio);\n  function Radio($container) {\n    var _this;\n    _classCallCheck(this, Radio);\n    var $filter = $container.find('.jet-radio-list');\n    _this = _super.call(this, $container, $filter, $filter.find(':radio'));\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'radio');\n    _this.mergeSameQueryKeys = true;\n\n    // Init modules\n    _this.additionalFilterSettings = new modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__[\"default\"](_assertThisInitialized(_this));\n    _this.collapsibleList = new modules_ollapsibleList__WEBPACK_IMPORTED_MODULE_2__[\"default\"](_assertThisInitialized(_this));\n    return _this;\n  }\n  return _createClass(Radio);\n}(bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Radio.js?")}),"./js/filters/Range.js":
/*!*****************************!*\
  !*** ./js/filters/Range.js ***!
  \*****************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Range)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Range__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Range */ \"./js/bases/controls/Range.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Range = /*#__PURE__*/function (_RangeControl) {\n  _inherits(Range, _RangeControl);\n  var _super = _createSuper(Range);\n  function Range($container) {\n    var _this;\n    _classCallCheck(this, Range);\n    var $filter = $container.find('.jet-range');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'range');\n    return _this;\n  }\n  return _createClass(Range);\n}(bases_controls_Range__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Range.js?")}),"./js/filters/Rating.js":
/*!******************************!*\
  !*** ./js/filters/Rating.js ***!
  \******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Rating)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Rating__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Rating */ \"./js/bases/controls/Rating.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Rating = /*#__PURE__*/function (_RatingControl) {\n  _inherits(Rating, _RatingControl);\n  var _super = _createSuper(Rating);\n  function Rating($container) {\n    var _this;\n    _classCallCheck(this, Rating);\n    var $filter = $container.find('.jet-rating');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'rating');\n    return _this;\n  }\n  return _createClass(Rating);\n}(bases_controls_Rating__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Rating.js?")}),"./js/filters/Search.js":
/*!******************************!*\
  !*** ./js/filters/Search.js ***!
  \******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Search)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Search__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Search */ \"./js/bases/controls/Search.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Search = /*#__PURE__*/function (_SearchControl) {\n  _inherits(Search, _SearchControl);\n  var _super = _createSuper(Search);\n  function Search($container) {\n    var _this;\n    _classCallCheck(this, Search);\n    var $filter = $container.find('.jet-search-filter');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'search');\n    return _this;\n  }\n  return _createClass(Search);\n}(bases_controls_Search__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Search.js?")}),"./js/filters/Select.js":
/*!******************************!*\
  !*** ./js/filters/Select.js ***!
  \******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Select)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Select */ \"./js/bases/controls/Select.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Select = /*#__PURE__*/function (_SelectControl) {\n  _inherits(Select, _SelectControl);\n  var _super = _createSuper(Select);\n  function Select($container) {\n    var _this;\n    _classCallCheck(this, Select);\n    var $filter = $container.find('.jet-select');\n    _this = _super.call(this, $container, $filter);\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'select');\n    _this.mergeSameQueryKeys = true;\n    return _this;\n  }\n  return _createClass(Select);\n}(bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Select.js?")}),"./js/filters/SelectHierarchical.js":
/*!******************************************!*\
  !*** ./js/filters/SelectHierarchical.js ***!
  \******************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ SelectHierarchical)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Select */ \"./js/bases/controls/Select.js\");\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar SelectHierarchical = /*#__PURE__*/function () {\n  function SelectHierarchical($container) {\n    var _this = this;\n    _classCallCheck(this, SelectHierarchical);\n    _defineProperty(this, \"name\", 'select-hierarchical');\n    _defineProperty(this, \"filters\", []);\n    var $filters = $container.find('.jet-select');\n    if (!$filters.length) return;\n    $filters.each(function (index) {\n      var $filter = $filters.eq(index);\n      var filter = new bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__[\"default\"]($container, $filter);\n      filter.hierarchicalInstance = _this;\n      filter.name = 'select';\n      filter.$container = $container;\n      filter.isHierarchy = true;\n      filter.depth = index;\n      _this.filters.push(filter);\n\n      // overwrite processData method\n      filter.processData = function () {\n        _this.hierarchicalFilterProcessData(filter);\n      };\n    });\n    this.isHierarchy = true;\n    this.indexer = $container.hasClass('jet-filter-indexed');\n    this.lastFilter = this.filters[this.filters.length - 1];\n    this.filterId = this.lastFilter.filterId;\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('fiter/change', function (filter) {\n      if (filter.filterId !== _this.filterId || filter.isReload && filter.applyOnChanging) return;\n      _this.getNextHierarchyLevels(filter);\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('fiters/remove', function (removeFilter) {\n      if (!_this.lastFilter.isCurrentProvider(removeFilter)) return;\n      _this.clearHierarchyLevels();\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('hierarchyFilters/update', function (filters) {\n      if (filters[_this.filterId]) _this.updateHierarchyLevels();\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].subscribe('hierarchyFilters/updateLevels', function (filter, data) {\n      if (_this.filterId !== filter.filterId) return;\n      for (var i = 1; i < _this.count; i++) {\n        var currFilter = _this.filters[i],\n          newControlContent = $(data['level_' + i]).find('select').html();\n        if (newControlContent) {\n          currFilter.$select.html(newControlContent);\n          _this.updateFilterIndexer(currFilter);\n        }\n      }\n    });\n\n    // clearing select control in next tick from filling with browser cache after returning to page\n    setTimeout(function () {\n      _this.filters.forEach(function (filter) {\n        if (!filter.dataValue) filter.$select.val('');\n      });\n    });\n  }\n  _createClass(SelectHierarchical, [{\n    key: \"setData\",\n    value: function setData(newData) {\n      for (var index = 0; index < newData.length; index++) {\n        var data = newData[index];\n        var filter = this.filters[index];\n        if (!filter) continue;\n        filter.dataValue = data;\n      }\n      this.updateHierarchyLevels();\n    }\n  }, {\n    key: \"hierarchicalFilterProcessData\",\n    value: function hierarchicalFilterProcessData(filter) {\n      filter.dataValue = filter.$selected.val();\n      if (filter.additionalFilterSettings) filter.additionalFilterSettings.dataUpdated();\n    }\n  }, {\n    key: \"getNextHierarchyLevels\",\n    value: function getNextHierarchyLevels(filter) {\n      var depth = filter.depth + 1,\n        values = [];\n      if (!depth) return;\n      for (var i = depth; i < this.filters.length; i++) {\n        this.filters[i].reset();\n        this.filters[i].showPreloader();\n      }\n      for (var _i = 0; _i < depth; _i++) {\n        var currFilter = this.filters[_i];\n        values.push({\n          value: currFilter.data,\n          tax: currFilter.queryVar\n        });\n      }\n      this.ajaxRequest({\n        values: values,\n        depth: depth,\n        args: filter.layoutOptions || false\n      });\n    }\n  }, {\n    key: \"updateHierarchyLevels\",\n    value: function updateHierarchyLevels() {\n      var _this2 = this;\n      var values = [];\n      var args = null;\n      this.filters.forEach(function (filter) {\n        if (filter.dataValue) {\n          if (args === null) args = filter.layoutOptions || false;\n          values.push({\n            value: filter.data,\n            tax: filter.queryVar\n          });\n          filter.showPreloader();\n        }\n      });\n      this.ajaxRequest({\n        values: values,\n        args: args\n      }, function () {\n        _this2.filters.forEach(function (filter) {\n          filter.setData(filter.data);\n        });\n        var firstFilter = _this2.filters[0];\n        if (firstFilter) includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('activeItems/rebuild', firstFilter.provider, firstFilter.queryId);\n      });\n    }\n  }, {\n    key: \"clearHierarchyLevels\",\n    value: function clearHierarchyLevels() {\n      var _this$filters = _toArray(this.filters),\n        hierarchyLevels = _this$filters.slice(1);\n      hierarchyLevels.forEach(function (hierarchyLevel) {\n        hierarchyLevel.$select.find('option').each(function (index, item) {\n          if (index === 0) return;\n          var $option = $(item);\n          $option.remove();\n        });\n      });\n    }\n  }, {\n    key: \"ajaxRequest\",\n    value: function ajaxRequest(data, callback) {\n      var _this3 = this;\n      var values = data.values,\n        _data$depth = data.depth,\n        depth = _data$depth === void 0 ? false : _data$depth,\n        _data$indexer = data.indexer,\n        indexer = _data$indexer === void 0 ? this.indexer : _data$indexer,\n        _data$args = data.args,\n        args = _data$args === void 0 ? false : _data$args;\n      var requestData = {\n        action: 'jet_smart_filters_get_hierarchy_level',\n        filter_id: this.filterId,\n        values: values\n      };\n      if (depth) requestData.depth = depth;\n      if (indexer) requestData.indexer = indexer;\n      if (args) requestData.args = args;\n      $.ajax({\n        url: JetSmartFilterSettings.ajaxurl,\n        type: 'POST',\n        dataType: 'json',\n        data: requestData\n      }).done(function (response) {\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('hierarchyFilters/updateLevels', _this3, response.data);\n        if (typeof callback === 'function') callback();\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_1__[\"default\"].publish('hierarchyFilters/levelsUpdated', _this3.filterId);\n      }).always(function () {\n        _this3.filters.forEach(function (filter) {\n          filter.hidePreloader();\n        });\n      });\n    }\n  }, {\n    key: \"updateFilterIndexer\",\n    value: function updateFilterIndexer(filter) {\n      if (!filter.indexer) return;\n\n      // if \"Apply Type\" selected \"Page reload\"\n      var isApplyTypeReload = filter.isReload;\n\n      // if \"Change Counters\" selected \"Never\"\n      var isChangeCountersNever = filter.indexer.changeCounte === 'never' ? true : false;\n      if (isApplyTypeReload || isChangeCountersNever) filter.indexer.set();\n    }\n\n    // Getters\n  }, {\n    key: \"count\",\n    get: function get() {\n      return this.filters.length;\n    }\n  }]);\n  return SelectHierarchical;\n}();\n\n\n//# sourceURL=webpack:///./js/filters/SelectHierarchical.js?")}),"./js/filters/Sorting.js":
/*!*******************************!*\
  !*** ./js/filters/Sorting.js ***!
  \*******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Sorting)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Select */ \"./js/bases/controls/Select.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar Sorting = /*#__PURE__*/function (_SelectControl) {\n  _inherits(Sorting, _SelectControl);\n  var _super = _createSuper(Sorting);\n  function Sorting($container) {\n    var _this;\n    _classCallCheck(this, Sorting);\n    var $filter = $container.find('.jet-sorting');\n    _this = _super.call(this, $container, $filter, $filter.find('.jet-sorting-select'));\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'sorting');\n    _this.mergeSameQueryKeys = true;\n    return _this;\n  }\n  return _createClass(Sorting);\n}(bases_controls_Select__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Sorting.js?")}),"./js/filters/Visual.js":
/*!******************************!*\
  !*** ./js/filters/Visual.js ***!
  \******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Visual)\n/* harmony export */ });\n/* harmony import */ var bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/controls/Checkbox */ \"./js/bases/controls/Checkbox.js\");\n/* harmony import */ var modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! modules/AdditionalFilterSettings */ \"./js/modules/AdditionalFilterSettings.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, \"prototype\", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\nfunction _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } else if (call !== void 0) { throw new TypeError(\"Derived constructors may only return object or undefined\"); } return _assertThisInitialized(self); }\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar Visual = /*#__PURE__*/function (_CheckboxControl) {\n  _inherits(Visual, _CheckboxControl);\n  var _super = _createSuper(Visual);\n  function Visual($container) {\n    var _this;\n    _classCallCheck(this, Visual);\n    var $filter = $container.find('.jet-color-image-list');\n    _this = _super.call(this, $container, $filter, $filter.find('.jet-color-image-list__input'));\n    _defineProperty(_assertThisInitialized(_this), \"name\", 'visual');\n    _this.mergeSameQueryKeys = true;\n\n    // Init modules\n    _this.additionalFilterSettings = new modules_AdditionalFilterSettings__WEBPACK_IMPORTED_MODULE_1__[\"default\"](_assertThisInitialized(_this));\n    return _this;\n  }\n  return _createClass(Visual);\n}(bases_controls_Checkbox__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n\n//# sourceURL=webpack:///./js/filters/Visual.js?")}),"./js/filters/index.js":
/*!*****************************!*\
  !*** ./js/filters/index.js ***!
  \*****************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var bases_Filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bases/Filter */ \"./js/bases/Filter.js\");\n/* harmony import */ var _CheckBoxes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CheckBoxes */ \"./js/filters/CheckBoxes.js\");\n/* harmony import */ var _CheckRange__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CheckRange */ \"./js/filters/CheckRange.js\");\n/* harmony import */ var _Select__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Select */ \"./js/filters/Select.js\");\n/* harmony import */ var _SelectHierarchical__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SelectHierarchical */ \"./js/filters/SelectHierarchical.js\");\n/* harmony import */ var _Range__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Range */ \"./js/filters/Range.js\");\n/* harmony import */ var _DateRange__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DateRange */ \"./js/filters/DateRange.js\");\n/* harmony import */ var _DatePeriod__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./DatePeriod */ \"./js/filters/DatePeriod.js\");\n/* harmony import */ var _Radio__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Radio */ \"./js/filters/Radio.js\");\n/* harmony import */ var _Rating__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Rating */ \"./js/filters/Rating.js\");\n/* harmony import */ var _Visual__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Visual */ \"./js/filters/Visual.js\");\n/* harmony import */ var _Alphabet__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Alphabet */ \"./js/filters/Alphabet.js\");\n/* harmony import */ var _Search__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Search */ \"./js/filters/Search.js\");\n/* harmony import */ var _Sorting__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Sorting */ \"./js/filters/Sorting.js\");\n/* harmony import */ var _ButtonApply__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ButtonApply */ \"./js/filters/ButtonApply.js\");\n/* harmony import */ var _ButtonRemove__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./ButtonRemove */ \"./js/filters/ButtonRemove.js\");\n/* harmony import */ var _Pagination__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Pagination */ \"./js/filters/Pagination.js\");\n/* harmony import */ var _ActiveFilters__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./ActiveFilters */ \"./js/filters/ActiveFilters.js\");\n/* harmony import */ var _ActiveTags__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./ActiveTags */ \"./js/filters/ActiveTags.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  BasicFilter: bases_Filter__WEBPACK_IMPORTED_MODULE_0__[\"default\"],\n  CheckBoxes: _CheckBoxes__WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  CheckRange: _CheckRange__WEBPACK_IMPORTED_MODULE_2__[\"default\"],\n  Select: _Select__WEBPACK_IMPORTED_MODULE_3__[\"default\"],\n  SelectHierarchical: _SelectHierarchical__WEBPACK_IMPORTED_MODULE_4__[\"default\"],\n  Range: _Range__WEBPACK_IMPORTED_MODULE_5__[\"default\"],\n  DateRange: _DateRange__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n  DatePeriod: _DatePeriod__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n  Radio: _Radio__WEBPACK_IMPORTED_MODULE_8__[\"default\"],\n  Rating: _Rating__WEBPACK_IMPORTED_MODULE_9__[\"default\"],\n  Visual: _Visual__WEBPACK_IMPORTED_MODULE_10__[\"default\"],\n  Alphabet: _Alphabet__WEBPACK_IMPORTED_MODULE_11__[\"default\"],\n  Search: _Search__WEBPACK_IMPORTED_MODULE_12__[\"default\"],\n  Sorting: _Sorting__WEBPACK_IMPORTED_MODULE_13__[\"default\"],\n  ButtonApply: _ButtonApply__WEBPACK_IMPORTED_MODULE_14__[\"default\"],\n  ButtonRemove: _ButtonRemove__WEBPACK_IMPORTED_MODULE_15__[\"default\"],\n  Pagination: _Pagination__WEBPACK_IMPORTED_MODULE_16__[\"default\"],\n  ActiveFilters: _ActiveFilters__WEBPACK_IMPORTED_MODULE_17__[\"default\"],\n  ActiveTags: _ActiveTags__WEBPACK_IMPORTED_MODULE_18__[\"default\"]\n});\n\n//# sourceURL=webpack:///./js/filters/index.js?")}),"./js/includes/editor-mode.js":
/*!************************************!*\
  !*** ./js/includes/editor-mode.js ***!
  \************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  initFilter: function initFilter(filterName) {\n    var $scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : $('body');\n    switch (filterName) {\n      case 'checkboxes':\n        init('CheckBoxes');\n        break;\n      case 'check-range':\n        init('CheckRange');\n        break;\n      case 'radio':\n        init('Radio');\n        break;\n      case 'color-image':\n        init('Visual');\n        break;\n      case 'range':\n        init('Range');\n        break;\n      case 'date-range':\n        init('DateRange');\n        break;\n      case 'date-period':\n        init('DatePeriod');\n        break;\n    }\n    function init(filterKey) {\n      var $filters = $scope.find('.' + window.JetSmartFilters.filtersList[filterKey]);\n      if (!$filters.length) return;\n      $filters.each(function (index) {\n        new window.JetSmartFilters.filters[filterKey]($filters.eq(index));\n      });\n    }\n  },\n  intiAllFilters: function intiAllFilters() {\n    var _this = this;\n    var $scope = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $('body');\n    window.JetSmartFilters.filterNames.forEach(function (filterName) {\n      _this.initFilter(filterName, $scope);\n    });\n  }\n});\n\n//# sourceURL=webpack:///./js/includes/editor-mode.js?")}),"./js/includes/epro-compat.js":
/*!************************************!*\
  !*** ./js/includes/epro-compat.js ***!
  \************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  archivePostsClass: '.elementor-widget-archive-posts',\n  defaultPostsClass: '.elementor-widget-posts',\n  postsSettings: {},\n  skin: 'archive_classic',\n  addSubscribers: function addSubscribers() {\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('provider/content-rendered', this.eproPostRendered.bind(this));\n  },\n  eproPostRendered: function eproPostRendered(providerName, $provider) {\n    if ('epro-archive' === providerName || 'epro-posts' === providerName) {\n      var postsSelector = this.defaultPostsClass,\n        $archive = null,\n        widgetName = 'posts',\n        hasMasonry = false;\n      if ('epro-archive' === providerName) {\n        postsSelector = this.archivePostsClass;\n        widgetName = 'archive-posts';\n      }\n      $archive = $provider.parent(postsSelector);\n      this.fitImages($archive);\n      this.postsSettings = $archive.data('settings');\n      if ('widget' === $archive.data('element_type')) {\n        this.skin = $archive.data('widget_type');\n      } else {\n        this.skin = $archive.data('element_type');\n      }\n      this.skin = this.skin.split(widgetName + '.');\n      this.skin = this.skin[1];\n      hasMasonry = this.postsSettings[this.skin + '_masonry'];\n      if ('yes' === hasMasonry) {\n        setTimeout(this.initMasonry($archive), 0);\n      }\n    }\n  },\n  initMasonry: function initMasonry($archive) {\n    var $container = $archive.find('.elementor-posts-container'),\n      $posts = $container.find('.elementor-post'),\n      settings = this.postsSettings,\n      colsCount = 1,\n      hasMasonry = true;\n    $posts.css({\n      marginTop: '',\n      transitionDuration: ''\n    });\n    var currentDeviceMode = window.elementorFrontend.getCurrentDeviceMode();\n    switch (currentDeviceMode) {\n      case 'mobile':\n        colsCount = settings[this.skin + '_columns_mobile'];\n        break;\n      case 'tablet':\n        colsCount = settings[this.skin + '_columns_tablet'];\n        break;\n      default:\n        colsCount = settings[this.skin + '_columns'];\n    }\n    hasMasonry = colsCount >= 2;\n    $container.toggleClass('elementor-posts-masonry', hasMasonry);\n    if (!hasMasonry) {\n      $container.height('');\n      return;\n    }\n    var verticalSpaceBetween = settings[this.skin + '_row_gap']['size'];\n    if (!verticalSpaceBetween) {\n      verticalSpaceBetween = settings[this.skin + '_item_gap']['size'];\n    }\n    var masonry = new elementorModules.utils.Masonry({\n      container: $container,\n      items: $posts.filter(':visible'),\n      columnsCount: colsCount,\n      verticalSpaceBetween: verticalSpaceBetween\n    });\n    masonry.run();\n  },\n  fitImage: function fitImage($post) {\n    var $imageParent = $post.find('.elementor-post__thumbnail'),\n      $image = $imageParent.find('img'),\n      image = $image[0];\n    if (!image) {\n      return;\n    }\n    var imageParentRatio = $imageParent.outerHeight() / $imageParent.outerWidth(),\n      imageRatio = image.naturalHeight / image.naturalWidth;\n    $imageParent.toggleClass('elementor-fit-height', imageRatio < imageParentRatio);\n  },\n  fitImages: function fitImages($element) {\n    var _this = this;\n    var itemRatio = getComputedStyle($element[0], ':after').content;\n    $element.find('.elementor-posts-container').toggleClass('elementor-has-item-ratio', !!itemRatio.match(/\\d/));\n    $element.find('.elementor-post').each(function (index, item) {\n      var $post = $(item),\n        $image = $post.find('.elementor-post__thumbnail img');\n      _this.fitImage($post);\n      $image.on('load', function () {\n        _this.fitImage($post);\n      });\n    });\n  }\n});\n\n//# sourceURL=webpack:///./js/includes/epro-compat.js?")}),"./js/includes/event-bus.js":
/*!**********************************!*\
  !*** ./js/includes/event-bus.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  channels: {},\n  subscribe: function subscribe(channelName, listener) {\n    var addToEnd = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n    if (!this.channels[channelName]) {\n      this.channels[channelName] = [];\n    }\n    this.channels[channelName][addToEnd ? 'push' : 'unshift'](listener);\n  },\n  publish: function publish(channelName) {\n    var _arguments = arguments;\n    var channel = this.channels[channelName];\n    if (!channel || !channel.length) return;\n    channel.forEach(function (listener) {\n      return listener.apply(void 0, _toConsumableArray(Array.from(_arguments).splice(1)));\n    });\n  }\n});\n\n//# sourceURL=webpack:///./js/includes/event-bus.js?")}),"./js/includes/filters-ui.js":
/*!***********************************!*\
  !*** ./js/includes/filters-ui.js ***!
  \***********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar filtersUI = {\n  datePicker: {\n    init: function init(props) {\n      var $input = props.$input,\n        _props$id = props.id,\n        id = _props$id === void 0 ? false : _props$id,\n        _props$datepickerOpti = props.datepickerOptions,\n        datepickerOptions = _props$datepickerOpti === void 0 ? false : _props$datepickerOpti,\n        weekStart = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'misc', 'week_start') || 1,\n        defaultOptions = _objectSpread(_objectSpread({\n          dateFormat: 'mm/dd/yy',\n          firstDay: parseInt(weekStart, 10)\n        }, filtersUI.datePicker.texts), {}, {\n          beforeShow: function beforeShow(textbox, instance) {\n            if (id) {\n              var $calendar = instance.dpDiv;\n              $calendar.addClass('jet-smart-filters-datepicker-' + id);\n            }\n          }\n        });\n      return $input.datepicker(datepickerOptions ? Object.assign(defaultOptions, datepickerOptions) : defaultOptions);\n    },\n    formatDate: function formatDate(date) {\n      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'mm/dd/yy';\n      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n      var texts = filtersUI.datePicker.texts;\n      var defaultOptions = {\n        monthNames: texts.monthNames,\n        monthNamesShort: texts.monthNamesShort,\n        dayNames: texts.dayNames,\n        dayNamesShort: texts.dayNamesShort\n      };\n      return $.datepicker.formatDate(dateFormat, date, Object.assign(defaultOptions, options));\n    },\n    parseDate: function parseDate(dateString) {\n      var dateFormat = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'mm/dd/yy';\n      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n      var texts = filtersUI.datePicker.texts;\n      var defaultOptions = {\n        monthNames: texts.monthNames,\n        monthNamesShort: texts.monthNamesShort,\n        dayNames: texts.dayNames,\n        dayNamesShort: texts.dayNamesShort\n      };\n      var output = {\n        date: $.datepicker.parseDate(dateFormat, dateString, Object.assign(defaultOptions, options)),\n        value: ''\n      };\n      output.value = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.convertDate)(output.date) || '';\n      return output;\n    },\n    get texts() {\n      var texts = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'datePickerData');\n      return {\n        closeText: texts.closeText,\n        prevText: texts.prevText,\n        nextText: texts.nextText,\n        currentText: texts.currentText,\n        monthNames: texts.monthNames,\n        monthNamesShort: texts.monthNamesShort,\n        dayNames: texts.dayNames,\n        dayNamesShort: texts.dayNamesShort,\n        dayNamesMin: texts.dayNamesMin,\n        weekHeader: texts.weekHeader\n      };\n    }\n  },\n  dateRange: {\n    inputSelector: '.jet-date-range__input',\n    submitSelector: '.jet-date-range__submit',\n    fromSelector: '.jet-date-range__from',\n    toSelector: '.jet-date-range__to',\n    init: function init(props) {\n      var _props$id2 = props.id,\n        id = _props$id2 === void 0 ? false : _props$id2,\n        _props$$container = props.$container,\n        $container = _props$$container === void 0 ? false : _props$$container,\n        _props$$dateRangeInpu = props.$dateRangeInput,\n        $dateRangeInput = _props$$dateRangeInpu === void 0 ? $dateRangeInput || $container.find(filtersUI.dateRange.inputSelector) : _props$$dateRangeInpu,\n        _props$$dateRangeFrom = props.$dateRangeFrom,\n        $dateRangeFrom = _props$$dateRangeFrom === void 0 ? $dateRangeFrom || $container.find(filtersUI.dateRange.fromSelector) : _props$$dateRangeFrom,\n        _props$$dateRangeTo = props.$dateRangeTo,\n        $dateRangeTo = _props$$dateRangeTo === void 0 ? $dateRangeTo || $container.find(filtersUI.dateRange.toSelector) : _props$$dateRangeTo,\n        _props$onChange = props.onChange,\n        onChange = _props$onChange === void 0 ? onChange || undefined : _props$onChange,\n        dateFormat = $dateRangeInput.data('date-format') || 'mm/dd/yy',\n        minDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.parseDateExpression)($dateRangeInput.data('mindate')) || null,\n        maxDate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.parseDateExpression)($dateRangeInput.data('maxdate')) || null;\n      var datepickerOptions = {\n        dateFormat: dateFormat,\n        minDate: minDate,\n        maxDate: maxDate\n      };\n      var from = filtersUI.datePicker.init({\n        $input: $dateRangeFrom,\n        id: id,\n        datepickerOptions: datepickerOptions\n      }).on('change', function () {\n        var fromDate = filtersUI.datePicker.parseDate($dateRangeFrom.val(), dateFormat),\n          toDate = filtersUI.datePicker.parseDate($dateRangeTo.val(), dateFormat);\n        if (fromDate.value || toDate.value) {\n          $dateRangeInput.val(fromDate.value + '-' + toDate.value);\n        } else {\n          $dateRangeInput.val('');\n        }\n        if (onChange) onChange('from', fromDate.date);\n        to.datepicker('option', 'minDate', fromDate.date || minDate);\n      });\n      var to = filtersUI.datePicker.init({\n        $input: $dateRangeTo,\n        id: id,\n        datepickerOptions: datepickerOptions\n      }).on('change', function () {\n        var fromDate = filtersUI.datePicker.parseDate($dateRangeFrom.val(), dateFormat),\n          toDate = filtersUI.datePicker.parseDate($dateRangeTo.val(), dateFormat);\n        if (fromDate.value || toDate.value) {\n          $dateRangeInput.val(fromDate.value + '-' + toDate.value);\n        } else {\n          $dateRangeInput.val('');\n        }\n        if (onChange) onChange('from', fromDate.date);\n        from.datepicker('option', 'maxDate', toDate.date || maxDate);\n      });\n    }\n  }\n};\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filtersUI);\n\n//# sourceURL=webpack:///./js/includes/filters-ui.js?")}),"./js/includes/preloader.js":
/*!**********************************!*\
  !*** ./js/includes/preloader.js ***!
  \**********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ \"jquery\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar preloader = {\n  init: function init() {\n    var _this = this;\n    this.subscribers = [];\n    this.preloaderTemplate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'provider_preloader');\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('ajaxFilters/start-loading', function (provider, queryId) {\n      _this.action(_this.currentElements(provider, queryId), 'show');\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('ajaxFilters/end-loading', function (provider, queryId) {\n      _this.action(_this.currentElements(provider, queryId), 'hide');\n    });\n  },\n  subscribe: function subscribe(target, props) {\n    var _props$provider = props.provider,\n      provider = _props$provider === void 0 ? false : _props$provider,\n      _props$queryId = props.queryId,\n      queryId = _props$queryId === void 0 ? 'default' : _props$queryId,\n      _props$preloaderClass = props.preloaderClass,\n      preloaderClass = _props$preloaderClass === void 0 ? 'jet-filters-loading' : _props$preloaderClass;\n    if (!provider) return;\n    this.subscribers.push({\n      target: target,\n      provider: provider,\n      queryId: queryId,\n      preloaderClass: preloaderClass\n    });\n  },\n  action: function action(elements, _action) {\n    var _this2 = this;\n    elements.forEach(function (element) {\n      var target = element.target,\n        preloaderClass = element.preloaderClass;\n      var $el = target instanceof jQuery ? target : $(target);\n      switch (_action) {\n        case 'show':\n          $el.addClass(preloaderClass);\n          element.$preloader = $el.append(_this2.preloaderTemplate);\n          break;\n        case 'hide':\n          $el.removeClass(preloaderClass);\n          break;\n      }\n    });\n  },\n  currentElements: function currentElements(provider, queryId) {\n    return this.subscribers.filter(function (element) {\n      return element.provider === provider && element.queryId === queryId;\n    });\n  }\n};\nvar ProviderPreloader = /*#__PURE__*/function () {\n  function ProviderPreloader($preloader) {\n    _classCallCheck(this, ProviderPreloader);\n    this.$preloader = $preloader;\n    this.container = $preloader.parent();\n    this.handleEvent();\n    window.addEventListener('scroll', this);\n    window.addEventListener('resize', this);\n  }\n  _createClass(ProviderPreloader, [{\n    key: \"remove\",\n    value: function remove() {\n      window.removeEventListener('scroll', this);\n      window.removeEventListener('resize', this);\n    }\n  }, {\n    key: \"handleEvent\",\n    value: function handleEvent() {\n      var containerRect = this.container.getBoundingClientRect(),\n        preloaderStyle = window.getComputedStyle ? getComputedStyle(this.preloader, null) : this.preloader.currentStyle,\n        preloaderHeight = this.preloader.clientHeight + (parseInt(preloaderStyle.marginTop) || 0) + parseInt(preloaderStyle.marginBottom) || 0,\n        containerTop = containerRect.top,\n        containerHeight = containerRect.height,\n        centerPosition = window.innerHeight / 2 - preloaderHeight / 2,\n        topPosition = centerPosition - containerTop,\n        bottomPosition = containerHeight + containerTop - preloaderHeight - centerPosition,\n        isFixed = topPosition > 0 && bottomPosition > 0 ? true : false;\n      if (isFixed) {\n        this.preloader.style.position = 'fixed';\n        this.preloader.style.top = \"\".concat(centerPosition, \"px\");\n        this.preloader.style.left = \"\".concat(containerRect.left + containerRect.width / 2, \"px\");\n      } else {\n        this.preloader.style.position = 'absolute';\n        this.preloader.style.top = containerTop >= 0 ? '0px' : \"\".concat(containerHeight - preloaderHeight, \"px\");\n        this.preloader.style.left = '50%';\n      }\n    }\n  }]);\n  return ProviderPreloader;\n}();\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (preloader);\n\n//# sourceURL=webpack:///./js/includes/preloader.js?")}),"./js/includes/request.js":
/*!********************************!*\
  !*** ./js/includes/request.js ***!
  \********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  xhrs: {},\n  ajax: function ajax(data) {\n    var _this = this;\n    return new Promise(function (resolve, reject) {\n      var requestData = {},\n        url = data.url || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'ajaxurl'),\n        action = data.action || 'jet_smart_filters',\n        query = data.query || false,\n        paged = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.objectSlice)(query, 'jet_paged'),\n        provider = data.provider || false,\n        queryId = data.queryId || 'default',\n        props = data.props || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'props', provider, queryId) || {},\n        extra_props = data.extra_props || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'extra_props') || {},\n        defaults = data.defaults || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'queries', provider, queryId) || {},\n        settings = data.settings || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'settings', provider, queryId) || {},\n        referrerData = data.referrer_data || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'referrer_data') || false,\n        referrerURL = data.referrer_url || (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'referrer_url') || false,\n        indexingFilters = data.indexingFilters || false;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.someIsFalse)([url, action, query, provider, queryId])) {\n        reject('Not enough parameters. Check if the \"Provider\" and \"Query ID\" are set correctly');\n        return;\n      }\n      if (_this.xhrs[provider + '/' + queryId]) {\n        _this.xhrs[provider + '/' + queryId].abort();\n      }\n      requestData.action = action;\n      requestData.provider = provider + '/' + queryId;\n      requestData.query = query;\n      requestData.defaults = defaults;\n      requestData.settings = settings;\n      requestData.props = props;\n      if (paged > 1) {\n        requestData.paged = paged;\n      }\n      if (referrerData) {\n        requestData.referrer = referrerData;\n      }\n      if (indexingFilters) {\n        requestData.indexing_filters = indexingFilters;\n      }\n      var requestURL = url;\n      if (referrerURL) {\n        requestURL = referrerURL;\n      }\n      if (extra_props) Object.assign(requestData, extra_props);\n      _this.xhrs[provider + '/' + queryId] = $.ajax({\n        url: requestURL,\n        type: 'POST',\n        dataType: 'json',\n        data: requestData\n      }).done(function (response) {\n        resolve(response);\n      }).fail(function (jqXHR, exception) {\n        if (exception === 'abort') {\n          reject(false);\n        }\n        var msg = '';\n        if (jqXHR.status === 0) {\n          msg = 'Not connect.\\n Verify Network.';\n        } else if (jqXHR.status == 404) {\n          msg = 'Requested page not found. [404]';\n        } else if (jqXHR.status == 500) {\n          msg = 'Internal Server Error [500].';\n        } else if (exception === 'parsererror') {\n          msg = 'Requested JSON parse failed.';\n        } else if (exception === 'timeout') {\n          msg = 'Time out error.';\n        } else {\n          msg = 'Uncaught Error.\\n' + jqXHR.responseText;\n        }\n        reject(msg);\n      });\n    });\n  },\n  reload: function reload(urlParams) {\n    document.location = urlParams || window.location.pathname;\n  },\n  redirectWithGET: function redirectWithGET(getParams, redirectPath) {\n    var redirectInNewWindow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n    if (!redirectPath) return;\n    redirectPath = (redirectPath.charAt(0) !== '/' ? '/' : '') + redirectPath + (redirectPath.charAt(redirectPath.length - 1) !== '/' ? '/' : '');\n    var url = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.applyAliases)(redirectPath + getParams);\n    if (!(0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.isValidUrl)(url)) url = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'siteurl') + url;\n    window.open(url, redirectInNewWindow ? '_blank' : '_top');\n  },\n  redirectWithPOST: function redirectWithPOST(postParams, redirectPath) {\n    var redirectInNewWindow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n    if (!redirectPath) return;\n    if (!(0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.isValidUrl)(redirectPath)) redirectPath = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'siteurl') + '/' + redirectPath;\n    var $form = $('<form></form>').attr('method', 'post').attr('action', redirectPath);\n    if (redirectInNewWindow) $form.attr('target', '_blank');\n    postParams['jet-smart-filters-redirect'] = 1;\n    $.each(postParams, function (key, value) {\n      if (Array.isArray(value)) {\n        value.forEach(function (valueItem) {\n          $form.append(getField(key + '[]', valueItem));\n        });\n      } else {\n        if ('object' === _typeof(value) && null !== value) {\n          value = JSON.stringify(value);\n        }\n        $form.append(getField(key, value));\n      }\n    });\n    $($form).appendTo('body').submit();\n    function getField(key, value) {\n      var $field = $('<input></input>');\n      $field.attr('type', 'hidden');\n      $field.attr('name', key);\n      $field.attr('value', value);\n      return $field;\n    }\n  }\n});\n\n//# sourceURL=webpack:///./js/includes/request.js?")}),"./js/includes/template-parser.js":
/*!****************************************!*\
  !*** ./js/includes/template-parser.js ***!
  \****************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"render\": () => (/* binding */ render),\n/* harmony export */   \"replaceWithValue\": () => (/* binding */ replaceWithValue)\n/* harmony export */ });\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  render: render,\n  replaceWithValue: replaceWithValue\n});\nfunction render(html, options) {\n  var re = /\\/%(.+?)%\\//g,\n    reExp = /(^( )?(var|if|for|else|switch|case|break|{|}|;))(.*)?/g,\n    code = 'with(obj) { var r=[];\\n',\n    cursor = 0,\n    result,\n    match;\n  var add = function add(line, js) {\n    js ? code += line.match(reExp) ? line + '\\n' : 'r.push(' + line + ');\\n' : code += line != '' ? 'r.push(\"' + line.replace(/\"/g, '\\\\\"') + '\");\\n' : '';\n    return add;\n  };\n  while (match = re.exec(html)) {\n    add(html.slice(cursor, match.index))(match[1], true);\n    cursor = match.index + match[0].length;\n  }\n  add(html.substr(cursor, html.length - cursor));\n  code = (code + 'return r.join(\"\"); }').replace(/[\\r\\t\\n]/g, ' ');\n  try {\n    result = new Function('obj', code).apply(options, [options]);\n  } catch (err) {\n    console.error(\"'\" + err.message + \"'\", \" in \\n\\nCode:\\n\", code, \"\\n\");\n  }\n  return result;\n}\nfunction replaceWithValue(html, value) {\n  return html.replace(/\\/%\\s*\\$value\\s*%\\//g, value);\n}\n\n//# sourceURL=webpack:///./js/includes/template-parser.js?")}),"./js/includes/utility.js":
/*!********************************!*\
  !*** ./js/includes/utility.js ***!
  \********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"allTrue\": () => (/* binding */ allTrue),\n/* harmony export */   \"applyAliases\": () => (/* binding */ applyAliases),\n/* harmony export */   \"arrayMove\": () => (/* binding */ arrayMove),\n/* harmony export */   \"arrayRemoveByValue\": () => (/* binding */ arrayRemoveByValue),\n/* harmony export */   \"arrayRemoveObjectByKey\": () => (/* binding */ arrayRemoveObjectByKey),\n/* harmony export */   \"clone\": () => (/* binding */ clone),\n/* harmony export */   \"convertDate\": () => (/* binding */ convertDate),\n/* harmony export */   \"dateAddDay\": () => (/* binding */ dateAddDay),\n/* harmony export */   \"dateAddMonth\": () => (/* binding */ dateAddMonth),\n/* harmony export */   \"dateAddYear\": () => (/* binding */ dateAddYear),\n/* harmony export */   \"debounce\": () => (/* binding */ debounce),\n/* harmony export */   \"decodeHtmlEntities\": () => (/* binding */ decodeHtmlEntities),\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__),\n/* harmony export */   \"encodeHtmlEntities\": () => (/* binding */ encodeHtmlEntities),\n/* harmony export */   \"getElementPath\": () => (/* binding */ getElementPath),\n/* harmony export */   \"getNesting\": () => (/* binding */ getNesting),\n/* harmony export */   \"getProvider\": () => (/* binding */ getProvider),\n/* harmony export */   \"getProviderFilters\": () => (/* binding */ getProviderFilters),\n/* harmony export */   \"getThirdPartyUrlParams\": () => (/* binding */ getThirdPartyUrlParams),\n/* harmony export */   \"getUrlParams\": () => (/* binding */ getUrlParams),\n/* harmony export */   \"isEmpty\": () => (/* binding */ isEmpty),\n/* harmony export */   \"isEqual\": () => (/* binding */ isEqual),\n/* harmony export */   \"isFunction\": () => (/* binding */ isFunction),\n/* harmony export */   \"isNestingExist\": () => (/* binding */ isNestingExist),\n/* harmony export */   \"isNotEmpty\": () => (/* binding */ isNotEmpty),\n/* harmony export */   \"isObject\": () => (/* binding */ isObject),\n/* harmony export */   \"isValidUrl\": () => (/* binding */ isValidUrl),\n/* harmony export */   \"mergeData\": () => (/* binding */ mergeData),\n/* harmony export */   \"notObject\": () => (/* binding */ notObject),\n/* harmony export */   \"objectSlice\": () => (/* binding */ objectSlice),\n/* harmony export */   \"parseDateExpression\": () => (/* binding */ parseDateExpression),\n/* harmony export */   \"parseDateExpressionWithCurrent\": () => (/* binding */ parseDateExpressionWithCurrent),\n/* harmony export */   \"parseDateExpressionWithToday\": () => (/* binding */ parseDateExpressionWithToday),\n/* harmony export */   \"removeAliases\": () => (/* binding */ removeAliases),\n/* harmony export */   \"setNesting\": () => (/* binding */ setNesting),\n/* harmony export */   \"someIsFalse\": () => (/* binding */ someIsFalse),\n/* harmony export */   \"someIsTrue\": () => (/* binding */ someIsTrue),\n/* harmony export */   \"stringToBoolean\": () => (/* binding */ stringToBoolean)\n/* harmony export */ });\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : \"undefined\" != typeof Symbol && arr[Symbol.iterator] || arr[\"@@iterator\"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\nfunction _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({\n  isObject: isObject,\n  notObject: notObject,\n  objectSlice: objectSlice,\n  clone: clone,\n  arrayMove: arrayMove,\n  arrayRemoveByValue: arrayRemoveByValue,\n  arrayRemoveObjectByKey: arrayRemoveObjectByKey,\n  mergeData: mergeData,\n  isNotEmpty: isNotEmpty,\n  isEmpty: isEmpty,\n  isEqual: isEqual,\n  someIsTrue: someIsTrue,\n  someIsFalse: someIsFalse,\n  allTrue: allTrue,\n  isValidUrl: isValidUrl,\n  isFunction: isFunction,\n  isNestingExist: isNestingExist,\n  setNesting: setNesting,\n  getNesting: getNesting,\n  getUrlParams: getUrlParams,\n  getProvider: getProvider,\n  getProviderFilters: getProviderFilters,\n  convertDate: convertDate,\n  dateAddDay: dateAddDay,\n  dateAddMonth: dateAddMonth,\n  dateAddYear: dateAddYear,\n  parseDateExpression: parseDateExpression,\n  parseDateExpressionWithToday: parseDateExpressionWithToday,\n  parseDateExpressionWithCurrent: parseDateExpressionWithCurrent,\n  debounce: debounce,\n  stringToBoolean: stringToBoolean,\n  applyAliases: applyAliases,\n  removeAliases: removeAliases,\n  getElementPath: getElementPath,\n  decodeHtmlEntities: decodeHtmlEntities,\n  encodeHtmlEntities: encodeHtmlEntities\n});\nfunction isObject(x) {\n  return _typeof(x) === 'object' && x !== null;\n}\n;\nfunction notObject(x) {\n  return !isObject(x);\n}\n;\nfunction objectSlice(obj, key) {\n  if (!obj.hasOwnProperty(key)) return false;\n  var keyValue = obj[key];\n  delete obj[key];\n  return keyValue;\n}\n;\nfunction clone(o) {\n  var output, v, key;\n  output = Array.isArray(o) ? [] : {};\n  for (key in o) {\n    v = o[key];\n    output[key] = _typeof(v) === 'object' ? clone(v) : v;\n  }\n  return output;\n}\nfunction arrayMove(arr, startIndex, endIndex) {\n  while (startIndex < 0) {\n    startIndex += arr.length;\n  }\n  while (endIndex < 0) {\n    endIndex += arr.length;\n  }\n  if (endIndex >= arr.length) {\n    var k = endIndex - arr.length + 1;\n    while (k--) {\n      arr.push(undefined);\n    }\n  }\n  arr.splice(endIndex, 0, arr.splice(startIndex, 1)[0]);\n  return arr;\n}\n;\nfunction arrayRemoveByValue(array, val) {\n  var index = array.indexOf(val);\n  if (index > -1) {\n    array.splice(index, 1);\n  }\n}\nfunction arrayRemoveObjectByKey(array, key, val) {\n  var index = array.findIndex(function (o) {\n    return o[key] === val;\n  });\n  if (index > -1) {\n    array.splice(index, 1);\n  }\n  return array;\n}\nfunction mergeData() {\n  var args = Array.prototype.slice.call(arguments);\n  if (!args.length) return false;\n  if (args.length === 1) return args[0];\n  var outputData = [];\n  args.forEach(function (arg) {\n    outputData = outputData.concat(arg);\n  });\n  return _toConsumableArray(new Set(outputData));\n}\nfunction isNotEmpty(obj) {\n  switch (obj.constructor) {\n    case Object:\n      return Object.entries(obj).length ? true : false;\n    case Array:\n      return obj.length ? true : false;\n  }\n  return obj ? true : false;\n}\nfunction isEmpty(obj) {\n  return !isNotEmpty(obj);\n}\nfunction someIsTrue(arr) {\n  return arr.some(function (item) {\n    return Boolean(item);\n  });\n}\nfunction someIsFalse(arr) {\n  return arr.some(function (item) {\n    return !Boolean(item);\n  });\n}\nfunction allTrue(arr) {\n  return someIsFalse(arr) ? false : true;\n}\nfunction isValidUrl(string) {\n  try {\n    new URL(string);\n  } catch (_) {\n    return false;\n  }\n  return true;\n}\nfunction isFunction(variableToCheck) {\n  return variableToCheck instanceof Function ? true : false;\n}\nfunction isNestingExist(obj) {\n  var nesting = Array.from(arguments).splice(1);\n  var output = true;\n  var _iterator = _createForOfIteratorHelper(nesting),\n    _step;\n  try {\n    for (_iterator.s(); !(_step = _iterator.n()).done;) {\n      var key = _step.value;\n      if (!obj[key]) {\n        output = false;\n        break;\n      }\n      obj = obj[key];\n    }\n  } catch (err) {\n    _iterator.e(err);\n  } finally {\n    _iterator.f();\n  }\n  return output;\n}\nfunction setNesting(data, obj, nesting) {\n  var props = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};\n  if (!data) return;\n  var iterationObj = obj;\n  for (var index = 0; index < nesting.length; index++) {\n    var iterationKey = nesting[index],\n      isLast = index === nesting.length - 1 ? true : false;\n    if (isLast) {\n      if (iterationObj[iterationKey] && props.merge) {\n        iterationObj[iterationKey] = mergeData(iterationObj[iterationKey], data);\n      } else {\n        iterationObj[iterationKey] = data;\n      }\n    } else {\n      if (!iterationObj[iterationKey]) iterationObj[iterationKey] = {};\n      iterationObj = iterationObj[iterationKey];\n    }\n  }\n}\nfunction getNesting(obj) {\n  var nesting = Array.from(arguments).splice(1);\n  var isNestingExist = true;\n  var _iterator2 = _createForOfIteratorHelper(nesting),\n    _step2;\n  try {\n    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {\n      var key = _step2.value;\n      if (!obj[key]) {\n        isNestingExist = false;\n        break;\n      }\n      obj = obj[key];\n    }\n  } catch (err) {\n    _iterator2.e(err);\n  } finally {\n    _iterator2.f();\n  }\n  return isNestingExist ? obj : false;\n}\nfunction isEqual(value, other) {\n  var type = Object.prototype.toString.call(value);\n  if (type !== Object.prototype.toString.call(other)) {\n    return false;\n  }\n  if (['[object Array]', '[object Object]'].indexOf(type) < 0) {\n    return false;\n  }\n  var valueLen = type === '[object Array]' ? value.length : Object.keys(value).length,\n    otherLen = type === '[object Array]' ? other.length : Object.keys(other).length;\n  if (valueLen !== otherLen) {\n    return false;\n  }\n  var compare = function compare(item1, item2) {\n    var itemType = Object.prototype.toString.call(item1);\n    if (['[object Array]', '[object Object]'].indexOf(itemType) >= 0) {\n      if (!isEqual(item1, item2)) {\n        return false;\n      }\n    } else {\n      if (itemType !== Object.prototype.toString.call(item2)) {\n        return false;\n      }\n      if (itemType === '[object Function]') {\n        if (item1.toString() !== item2.toString()) {\n          return false;\n        }\n      } else {\n        if (item1 !== item2) {\n          return false;\n        }\n      }\n    }\n  };\n  if (type === '[object Array]') {\n    for (var i = 0; i < valueLen; i++) {\n      if (compare(value[i], other[i]) === false) {\n        return false;\n      }\n    }\n  } else {\n    for (var key in value) {\n      if (value.hasOwnProperty(key)) {\n        if (compare(value[key], other[key]) === false) {\n          return false;\n        }\n      }\n    }\n  }\n  return true;\n}\n;\nfunction getProvider(providerName) {\n  var queryId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'default';\n  return getNesting(JetSmartFilters, 'filterGroups', providerName + '/' + queryId);\n}\nfunction getProviderFilters(providerName) {\n  var queryId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'default';\n  var provider = getProvider(providerName, queryId);\n  if (!provider) return [];\n  return provider.uniqueFilters || [];\n}\nfunction getUrlParams() {\n  var url = removeAliases(window.location.pathname + window.location.search);\n  var paramsIndex = url.indexOf('?');\n  if (paramsIndex === -1) return {};\n  var urlParams = decodeURIComponent(url.slice(paramsIndex));\n  return (/^[?#]/.test(urlParams) ? urlParams.slice(1) : urlParams).split('&').reduce(function (params, param) {\n    var _param$split = param.split('='),\n      _param$split2 = _slicedToArray(_param$split, 2),\n      key = _param$split2[0],\n      value = _param$split2[1];\n    if (key) params[key] = value ? value.replace(/\\+/g, ' ') : '';\n    return params;\n  }, {});\n}\nfunction getThirdPartyUrlParams() {\n  var params = getUrlParams();\n  var validUrlParams = getNesting(JetSmartFilterSettings, 'misc', 'valid_url_params');\n  var output = '';\n  for (var paramKey in params) {\n    var paramValue = params[paramKey];\n    if (validUrlParams.includes(paramKey)) continue;\n    output += paramKey + (paramValue ? '=' + paramValue : '') + '&';\n  }\n  if (output) output = '?' + output.replace(/&+$/, '');\n  return output;\n}\nfunction convertDate(date) {\n  if (!date || !date.getTime()) return false;\n  return date.getFullYear() + '.' + (date.getMonth() + 1) + '.' + date.getDate();\n}\nfunction dateAddDay(date) {\n  var days = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;\n  date.setDate(date.getDate() + days);\n  return date;\n}\nfunction dateAddMonth(date) {\n  var months = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;\n  var d = date.getDate();\n  date.setMonth(date.getMonth() + months);\n  if (date.getDate() != d) {\n    date.setDate(0);\n  }\n  return date;\n}\nfunction dateAddYear(date) {\n  var years = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;\n  date.setFullYear(date.getFullYear() + years);\n  return date;\n}\nfunction parseDateExpression(dateExpression) {\n  if (!dateExpression) return false;\n  var date;\n  if (dateExpression.includes('today')) {\n    date = parseDateExpressionWithToday(dateExpression);\n  } else if (dateExpression.includes('current')) {\n    date = parseDateExpressionWithCurrent(dateExpression);\n  } else {\n    date = new Date(dateExpression);\n  }\n  if (!date || isNaN(date)) return false;\n  date.setHours(0, 0, 0, 0);\n  return date;\n}\nfunction parseDateExpressionWithToday(dateExpression) {\n  var result = new Date();\n  var regex = /([-+]\\s*\\d+(\\.\\d+)?\\s*\\w+)(?=\\s*[-+]|$)/g;\n  var matches = dateExpression.match(regex);\n  if (matches) matches.forEach(function (operationExpression) {\n    var operator = operationExpression.substring(0, 1);\n    var value = operator === '-' ? -parseInt(operationExpression.substring(1)) : parseInt(operationExpression.substring(1));\n    if (operationExpression.includes('day')) dateAddDay(result, value);\n    if (operationExpression.includes('week')) dateAddDay(result, value * 7);\n    if (operationExpression.includes('month')) dateAddMonth(result, value);\n    if (operationExpression.includes('year')) dateAddYear(result, value);\n  });\n  return result;\n}\nfunction parseDateExpressionWithCurrent(dateExpression) {\n  var currentDate = new Date();\n  var dateData = dateExpression.split('-', 3).map(function (item, index) {\n    if (item.includes('current')) switch (index) {\n      case 0:\n        item = currentDate.getFullYear();\n        break;\n      case 1:\n        item = currentDate.getMonth() + 1;\n        break;\n      case 2:\n        item = currentDate.getDate();\n        break;\n    }\n    return item;\n  });\n  return new Date(dateData.join('-'));\n}\nfunction debounce(callback, wait) {\n  var immediate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n  var timeout = null;\n  return function () {\n    var _arguments = arguments,\n      _this = this;\n    var callNow = immediate && !timeout;\n    var next = function next() {\n      return callback.apply(_this, _arguments);\n    };\n    clearTimeout(timeout);\n    timeout = setTimeout(next, wait);\n    if (callNow) {\n      next();\n    }\n  };\n}\nfunction stringToBoolean(string) {\n  if (typeof string === 'boolean') return string;\n  switch (string.toLowerCase().trim()) {\n    case 'true':\n    case 'yes':\n    case '1':\n      return true;\n    case 'false':\n    case 'no':\n    case '0':\n    case null:\n      return false;\n    default:\n      return Boolean(string);\n  }\n}\nfunction urlAliasesTransform(url, aliases) {\n  var reverse = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n  var useAliases = true;\n  if (!aliases) {\n    useAliases = stringToBoolean(getNesting(JetSmartFilterSettings, 'plugin_settings', 'use_url_aliases'));\n    aliases = getNesting(JetSmartFilterSettings, 'plugin_settings', 'url_aliases');\n  }\n  if (!useAliases || !aliases) return url;\n  var sitePath = getNesting(JetSmartFilterSettings, 'sitepath');\n  var isPathPresent = sitePath && url.indexOf(sitePath) === 0 ? true : false;\n  if (isPathPresent) url = url.slice(sitePath.length);\n  aliases.forEach(function (alias) {\n    if (!alias.needle || !alias.replacement) return;\n    url = reverse ? url.replace(alias.replacement, alias.needle) : url.replace(alias.needle, alias.replacement);\n  });\n  if (isPathPresent) url = sitePath + url;\n  return url;\n}\nfunction applyAliases(url) {\n  var aliases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n  return urlAliasesTransform(url, aliases, false);\n}\nfunction removeAliases(url) {\n  var aliases = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n  return urlAliasesTransform(url, aliases, true);\n}\nfunction getElementPath(node) {\n  var selector = '';\n  try {\n    while (node.parentElement) {\n      var siblings = Array.from(node.parentElement.children).filter(function (e) {\n        return e.tagName === node.tagName;\n      });\n      selector = (siblings.indexOf(node) ? \"\".concat(node.tagName, \":nth-of-type(\").concat(siblings.indexOf(node) + 1, \")\") : \"\".concat(node.tagName)) + \"\".concat(selector ? '>' : '').concat(selector);\n      node = node.parentElement;\n    }\n    return \"html > \".concat(selector.toLowerCase());\n  } catch (error) {\n    return false;\n  }\n}\nfunction decodeHtmlEntities(html) {\n  if (typeof str !== 'string') return str;\n  var entities = [['amp', '&'], ['apos', \"'\"], ['lt', '<'], ['gt', '>'], ['#39', \"'\"], ['#x27', \"'\"], ['#x2F', '/'], ['#x60', '`'], ['#x3D', '='], ['#x22', '\"'], ['#x20', ' ']];\n  for (var _i2 = 0, _entities = entities; _i2 < _entities.length; _i2++) {\n    var _entities$_i = _slicedToArray(_entities[_i2], 2),\n      code = _entities$_i[0],\n      char = _entities$_i[1];\n    var pattern = new RegExp(\"&\".concat(code, \";\"), 'g');\n    html = html.replace(pattern, char);\n  }\n  return html;\n}\nfunction encodeHtmlEntities(str) {\n  if (typeof str !== 'string') return str;\n  var entities = [['&', '&amp;'], ['$', '&#36;'], ['<', '&lt;'], ['>', '&gt;'], ['\"', '&quot;'], [\"'\", '&#39;'], ['/', '&#x2F;'], ['`', '&#x60;'], ['=', '&#x3D;'], [' ', '&#x20;']];\n  for (var _i3 = 0, _entities2 = entities; _i3 < _entities2.length; _i3++) {\n    var _entities2$_i = _slicedToArray(_entities2[_i3], 2),\n      char = _entities2$_i[0],\n      entity = _entities2$_i[1];\n    var pattern = new RegExp(\"\\\\\".concat(char), 'g');\n    str = str.replace(pattern, entity);\n  }\n  return str;\n}\n\n//# sourceURL=webpack:///./js/includes/utility.js?")}),"./js/index.js":
/*!*********************!*\
  !*** ./js/index.js ***!
  \*********************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _filters_initializer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./filters-initializer */ \"./js/filters-initializer.js\");\n/* harmony import */ var includes_editor_mode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/editor-mode.js */ \"./js/includes/editor-mode.js\");\n/* harmony import */ var _extensions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./extensions */ \"./js/extensions/index.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\n\n\n// Init JetSamrtFilters\n\n\n// Includes\n\n$(document).ready(function () {\n  window.JetPlugins.init(false, _filters_initializer__WEBPACK_IMPORTED_MODULE_0__[\"default\"].filterNames.map(function (filterName) {\n    return {\n      block: 'jet-smart-filters/' + filterName,\n      callback: function callback($scope) {\n        _filters_initializer__WEBPACK_IMPORTED_MODULE_0__[\"default\"].initFilter($scope);\n      }\n    };\n  }));\n});\n\n// If elementor\n$(window).on('elementor/frontend/init', function () {\n  _filters_initializer__WEBPACK_IMPORTED_MODULE_0__[\"default\"].filterNames.forEach(function (filterName) {\n    elementorFrontend.hooks.addAction('frontend/element_ready/jet-smart-filters-' + filterName + '.default', function ($scope) {\n      if (elementorFrontend.isEditMode()) {\n        // init filter in editor\n        includes_editor_mode_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].initFilter(filterName, $scope);\n      } else {\n        // init filter\n        var $filters = $scope.find('.jet-filter');\n        if (!$filters.length) return;\n        $filters.each(function (index) {\n          _filters_initializer__WEBPACK_IMPORTED_MODULE_0__[\"default\"].initFilter($filters.eq(index));\n        });\n      }\n    });\n  });\n});\n\n// If bricks\nwindow.JetSmartFiltersBricksInit = function () {\n  // init filter in editor\n  if (!window.bricksIsFrontend) includes_editor_mode_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].intiAllFilters();\n};\n\n// Extensions\n\n\n//# sourceURL=webpack:///./js/index.js?")}),"./js/modules/AdditionalFilterSettings.js":
/*!************************************************!*\
  !*** ./js/modules/AdditionalFilterSettings.js ***!
  \************************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AdditionalFilterSettings)\n/* harmony export */ });\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nvar AdditionalFilterSettings = /*#__PURE__*/function () {\n  function AdditionalFilterSettings(filter) {\n    _classCallCheck(this, AdditionalFilterSettings);\n    this.filter = filter;\n    this.$items = this.filter.$filter.find('.jet-filter-row');\n    this.inputNotEmptyClass = 'jet-input-not-empty';\n\n    // Search\n    this.searchClass = 'jet-filter-items-search';\n    this.$searchContainer = this.filter.$container.find(\".\".concat(this.searchClass));\n    if (this.$searchContainer.length) {\n      this.searchInit();\n    }\n\n    // MoreLess\n    this.morelessClass = 'jet-filter-items-moreless';\n    this.$moreless = this.filter.$container.find(\".\".concat(this.morelessClass));\n    if (this.$moreless.length) {\n      this.morelessInit();\n    }\n\n    // Dropdown\n    this.dropdownClass = 'jet-filter-items-dropdown';\n    this.$dropdown = this.filter.$container.find(\".\".concat(this.dropdownClass));\n    if (this.$dropdown.length) {\n      this.dropdownInit();\n    }\n    this.toggleItemsVisibility();\n  }\n\n  // Search\n  _createClass(AdditionalFilterSettings, [{\n    key: \"searchInit\",\n    value: function searchInit() {\n      var _this = this;\n      this.searchValue = '';\n      this.$searchInput = this.$searchContainer.find(\".\".concat(this.searchClass, \"__input\"));\n      this.$searchClear = this.$searchContainer.find(\".\".concat(this.searchClass, \"__clear\"));\n      if (this.$searchInput.length) this.$searchInput.on('keyup', function (evt) {\n        _this.searchApply(evt.target.value);\n      });\n      if (this.$searchClear.length) this.$searchClear.on('click', function () {\n        _this.searchClear();\n      });\n    }\n  }, {\n    key: \"searchApply\",\n    value: function searchApply(value) {\n      this.searchValue = value.toLowerCase();\n      if (this.searchValue) {\n        this.$searchInput.addClass(this.inputNotEmptyClass);\n      } else {\n        this.$searchInput.removeClass(this.inputNotEmptyClass);\n      }\n      this.toggleItemsVisibility();\n    }\n  }, {\n    key: \"searchClear\",\n    value: function searchClear() {\n      this.$searchInput.val('');\n      this.searchApply('');\n    }\n\n    // MoreLess\n  }, {\n    key: \"morelessInit\",\n    value: function morelessInit() {\n      var _this2 = this;\n      this.$morelessToggle = this.$moreless.find(\".\".concat(this.morelessClass, \"__toggle\"));\n      this.numberOfDisplayed = this.$moreless.data('less-items-count');\n      this.moreBtnText = this.$moreless.data('more-text');\n      this.lessBtnText = this.$moreless.data('less-text');\n      this.moreBtnClass = 'jet-more-btn';\n      this.lessBtnClass = 'jet-less-btn';\n      this.moreState = false;\n      this.$morelessToggle.addClass(this.moreBtnClass);\n      this.$morelessToggle.on('click', function () {\n        _this2.moreLessToggle();\n      });\n    }\n  }, {\n    key: \"moreLessToggle\",\n    value: function moreLessToggle() {\n      if (this.moreState) {\n        this.switchToLess();\n      } else {\n        this.switchToMore();\n      }\n    }\n  }, {\n    key: \"switchToMore\",\n    value: function switchToMore() {\n      this.moreState = true;\n      this.$morelessToggle.removeClass(this.moreBtnClass).addClass(this.lessBtnClass).text(this.lessBtnText);\n      this.toggleItemsVisibility();\n    }\n  }, {\n    key: \"switchToLess\",\n    value: function switchToLess() {\n      this.moreState = false;\n      this.$morelessToggle.removeClass(this.lessBtnClass).addClass(this.moreBtnClass).text(this.moreBtnText);\n      this.toggleItemsVisibility();\n    }\n\n    // Dropdown\n  }, {\n    key: \"dropdownInit\",\n    value: function dropdownInit() {\n      var _this3 = this;\n      this.$dropdownLabel = this.$dropdown.find(\".\".concat(this.dropdownClass, \"__label\"));\n      this.$dropdownBody = this.$dropdown.find(\".\".concat(this.dropdownClass, \"__body\"));\n      this.$dropdownItems = this.$dropdownBody.find('input:checkbox, input:radio');\n      this.dropdownOpenClass = 'jet-dropdown-open';\n      this.dropdownBodyPositionTopClass = 'jet-dropdown-position-top';\n      this.dropdownPlaceholderText = this.$dropdownLabel.html();\n      this.dropdownApplyButton = this.$dropdown.find(\".\".concat(this.dropdownClass, \"__apply-button\"));\n      ;\n      this.dropdownNselectedNumber = this.$dropdown.data('dropdown-n-selected');\n      this.dropdownNselectedText = this.$dropdown.data('dropdown-n-selected-text') || 'and {number} others';\n      this.dropdownNselectedEnabled = Boolean(this.dropdownNselectedNumber || this.dropdownNselectedNumber == 0);\n      this.dropdownState = false;\n      $(document).on('click', function (evt) {\n        _this3.documentClick(evt);\n      });\n      if (this.$dropdownLabel.length) {\n        this.$dropdownLabel.on('click', function () {\n          _this3.dropdownToggle();\n        });\n        this.$dropdownItems.on('click', function () {\n          _this3.dropDownItemsUpdate();\n        });\n      }\n      if (this.dropdownApplyButton.length) this.dropdownApplyButton.on('click', function () {\n        _this3.filter.processData();\n        _this3.filter.emitFiterApply();\n      });\n    }\n  }, {\n    key: \"dropdownToggle\",\n    value: function dropdownToggle() {\n      if (this.dropdownState) {\n        this.dropdownClose();\n      } else {\n        this.dropdownOpen();\n      }\n    }\n  }, {\n    key: \"dropdownClose\",\n    value: function dropdownClose() {\n      this.dropdownState = false;\n      this.$dropdown.removeClass(this.dropdownOpenClass);\n      this.$dropdown.removeClass(this.dropdownBodyPositionTopClass);\n    }\n  }, {\n    key: \"dropdownOpen\",\n    value: function dropdownOpen() {\n      var documentHeight = $(document).height();\n      this.dropdownState = true;\n      this.$dropdown.addClass(this.dropdownOpenClass);\n      if (this.$searchInput) this.$searchInput.focus();\n      var dropdowHeight = this.$dropdownLabel.outerHeight(true) + this.$dropdownBody.outerHeight(true);\n      var dropdownBodyOffsetTop = this.$dropdown.offset().top;\n      if (documentHeight > dropdowHeight && documentHeight < dropdownBodyOffsetTop + dropdowHeight) this.$dropdown.addClass(this.dropdownBodyPositionTopClass);\n    }\n  }, {\n    key: \"documentClick\",\n    value: function documentClick(evt) {\n      if (!$.contains(this.$dropdown.get(0), evt.target)) this.dropdownClose();\n    }\n  }, {\n    key: \"dropDownItemsUpdate\",\n    value: function dropDownItemsUpdate() {\n      var _this4 = this;\n      // remove all jQuery events to avoid memory leak\n      this.$dropdownLabel.find('*').off();\n      var $checked = this.filter.$checked;\n      var $selected = this.filter.$selected;\n      if ($checked && $checked.length) {\n        this.$dropdownLabel.html('');\n        var $items = $('<div class=\"jet-filter-items-dropdown__active\"></div>');\n        this.$dropdownLabel.append($items);\n        var $displayedItems = this.dropdownNselectedEnabled ? this.filter.$checked.slice(0, this.dropdownNselectedNumber) : this.filter.$checked;\n        $displayedItems.each(function (index) {\n          var $item = $displayedItems.eq(index);\n          $items.append($(\"<div class=\\\"jet-filter-items-dropdown__active__item\\\">\".concat($item.data('label'), \"<span class=\\\"jet-filter-items-dropdown__active__item__remove\\\">\\xD7</span></div>\")).one('click', function (evt) {\n            evt.stopPropagation();\n            _this4.filter.reset($item.val());\n            $item.trigger('change');\n          }));\n        });\n        if (this.dropdownNselectedEnabled && this.dropdownNselectedNumber < $checked.length) {\n          var othersCountText = this.dropdownNselectedText.replace('{number}', $checked.length - this.dropdownNselectedNumber);\n          $items.append($(\"<div class=\\\"jet-filter-items-dropdown__n-selected\\\">\".concat(othersCountText, \"</div>\")));\n        }\n      } else if ($selected && $selected.val()) {\n        this.$dropdownLabel.html($selected.data('label'));\n      } else {\n        this.$dropdownLabel.html(this.dropdownPlaceholderText);\n      }\n    }\n  }, {\n    key: \"dataUpdated\",\n    value: function dataUpdated() {\n      if (this.$dropdown.length && this.$dropdownLabel.length) this.dropDownItemsUpdate();\n    }\n  }, {\n    key: \"toggleItemsVisibility\",\n    value: function toggleItemsVisibility() {\n      var _this5 = this;\n      var $visibleItems = this.$items.filter(function (index) {\n        var $item = _this5.$items.eq(index),\n          $input = $item.find('input');\n\n        // ignore the item if it was hidden by the indexer as empty\n        if ($item.hasClass('jet-filter-row-hide')) return false;\n\n        // search value not found\n        if (_this5.searchValue && $input.data('label').toString().toLowerCase().indexOf(_this5.searchValue) === -1) {\n          $item.hide();\n          return false;\n        }\n        $item.show();\n        return true;\n      });\n\n      // MoreLess\n      if (this.numberOfDisplayed) {\n        if ($visibleItems.length > this.numberOfDisplayed) {\n          if (!this.moreState) {\n            // more than number of displayed\n            for (var index = this.numberOfDisplayed; index < $visibleItems.length; index++) {\n              $visibleItems.eq(index).hide();\n            }\n          }\n          this.$moreless.show();\n        } else {\n          this.$moreless.hide();\n        }\n      }\n    }\n  }]);\n  return AdditionalFilterSettings;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/AdditionalFilterSettings.js?")}),"./js/modules/AdditionalFilters.js":
/*!*****************************************!*\
  !*** ./js/modules/AdditionalFilters.js ***!
  \*****************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ AdditionalFilters)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar AdditionalFilters = /*#__PURE__*/function () {\n  function AdditionalFilters(filterGroup) {\n    var _this = this;\n    _classCallCheck(this, AdditionalFilters);\n    this.filterGroup = filterGroup;\n\n    // Event subscriptions\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('fiter/apply', function (parentFilter) {\n      if (!_this.isCurrentAdditionalProvider(parentFilter) || parentFilter.isReload) return;\n      _this.changeByParent(parentFilter);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('fiters/apply', function (parentApplyFilter) {\n      if (!_this.isCurrentAdditionalProvider(parentApplyFilter) || parentApplyFilter.isReload) return;\n      _this.applyFiltersByParent(parentApplyFilter);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('fiters/remove', function (parentRemoveFilter) {\n      if (!_this.isCurrentAdditionalProvider(parentRemoveFilter) || parentRemoveFilter.isReload) return;\n      _this.removeByParent(parentRemoveFilter);\n    }, true);\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('ajaxFilters/updated', function (provider, queryId) {\n      if (!_this.filterGroup.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      _this.filterGroup.additionalRequest = false;\n    }, true);\n  }\n  _createClass(AdditionalFilters, [{\n    key: \"changeByParent\",\n    value: function changeByParent(parentFilter) {\n      var isAdditionalFilterUpdated = this.updateAdditionalFilterByParent(parentFilter);\n      if (!isAdditionalFilterUpdated || parentFilter.applyType === 'reload') return;\n      this.filterGroup.additionalRequest = true;\n      this.filterGroup.applyFilterHandler(parentFilter.applyType);\n    }\n  }, {\n    key: \"applyFiltersByParent\",\n    value: function applyFiltersByParent(parentApplyFilter) {\n      var _this2 = this;\n      var isAdditionalFiltersUpdated = false;\n      this.parentProviderCurrentFilters(parentApplyFilter.provider, parentApplyFilter.queryId).forEach(function (parentFilter) {\n        var isAdditionalFilterUpdated = _this2.updateAdditionalFilterByParent(parentFilter);\n        if (!isAdditionalFilterUpdated || parentFilter.applyType === 'reload') return;\n        isAdditionalFiltersUpdated = true;\n      });\n      if (isAdditionalFiltersUpdated) {\n        this.filterGroup.additionalRequest = true;\n        this.filterGroup.applyFiltersHandler(parentApplyFilter.applyType);\n      }\n    }\n  }, {\n    key: \"updateAdditionalFilterByParent\",\n    value: function updateAdditionalFilterByParent(parentFilter) {\n      var additionalFilter = this.findInCollection(parentFilter);\n      if (!additionalFilter) return false;\n      additionalFilter.data = parentFilter.data;\n      this.filterGroup.updateSameFilters(additionalFilter);\n      if (parentFilter.isHierarchy) this.updateHierarchyLevelsByParent(parentFilter);\n      return true;\n    }\n  }, {\n    key: \"removeByParent\",\n    value: function removeByParent(parentRemoveFilter) {\n      this.resetFilters();\n      this.filterGroup.additionalRequest = true;\n      this.filterGroup.removeFiltersHandler(parentRemoveFilter.applyType);\n    }\n  }, {\n    key: \"updateProvider\",\n    value: function updateProvider() {\n      if (!this.filters.length) return;\n      this.filterGroup.currentQuery = {};\n      this.filterGroup.additionalRequest = true;\n      this.filterGroup.doAjax();\n    }\n  }, {\n    key: \"parentProviderCurrentFilters\",\n    value: function parentProviderCurrentFilters(provider, queryId) {\n      var _this3 = this;\n      return (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getProviderFilters)(provider, queryId).filter(function (parentFilter) {\n        return _this3.isCurrentAdditionalProvider(parentFilter);\n      });\n    }\n  }, {\n    key: \"resetFilters\",\n    value: function resetFilters() {\n      this.filters.forEach(function (filter) {\n        filter.data = false;\n      });\n    }\n  }, {\n    key: \"findInCollection\",\n    value: function findInCollection(parentFilter) {\n      return this.filters.find(function (collectionFilter) {\n        return getPropertiesKey(parentFilter) === getPropertiesKey(collectionFilter);\n      });\n      function getPropertiesKey(filter) {\n        return filter.name + '|' + filter.filterId + '|' + filter.queryKey;\n      }\n    }\n  }, {\n    key: \"isCurrentAdditionalProvider\",\n    value: function isCurrentAdditionalProvider(parentFilter) {\n      if (!parentFilter.additionalProviders || !Array.isArray(parentFilter.additionalProviders)) return false;\n      return parentFilter.additionalProviders.includes(this.filterGroup.providerKey) ? true : false;\n    }\n  }, {\n    key: \"updateHierarchyLevelsByParent\",\n    value: function updateHierarchyLevelsByParent(parentFilter) {\n      var _this4 = this;\n      parentFilter.hierarchicalInstance.filters.forEach(function (parentFilter) {\n        var filter = _this4.filters.find(function (filter) {\n          return filter.filterId === parentFilter.filterId && filter.depth === parentFilter.depth;\n        });\n        filter.data = parentFilter.data;\n      });\n    }\n  }, {\n    key: \"filters\",\n    get: function get() {\n      return this.filterGroup.filters.filter(function (filter) {\n        return filter.isAdditional;\n      });\n    }\n  }]);\n  return AdditionalFilters;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/AdditionalFilters.js?")}),"./js/modules/CustomProvider.js":
/*!**************************************!*\
  !*** ./js/modules/CustomProvider.js ***!
  \**************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ CustomProvider)\n/* harmony export */ });\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nvar CustomProvider = /*#__PURE__*/_createClass(function CustomProvider(filterGroup) {\n  var _this = this;\n  _classCallCheck(this, CustomProvider);\n  this.filterGroup = filterGroup;\n\n  // jetEngine Calendar add current query to request\n  $(document).on('jet-engine-request-calendar', function () {\n    var currentRequest = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetEngine, 'currentRequest');\n    if (!currentRequest || _this.filterGroup.provider !== 'jet-engine-calendar') return;\n    if (currentRequest.settings && currentRequest.settings.hasOwnProperty('_element_id')) {\n      var queryId = currentRequest.settings._element_id ? currentRequest.settings._element_id : 'default';\n      if (_this.filterGroup.queryId !== queryId) {\n        return;\n      }\n    }\n    currentRequest.query = _this.filterGroup.currentQuery;\n    currentRequest.provider = _this.filterGroup.provider + '/' + _this.filterGroup.queryId;\n    var monthData = currentRequest.month.split(' ');\n    if (2 === monthData.length && window.JetSmartFilterSettings.settings && window.JetSmartFilterSettings.settings[_this.filterGroup.provider] && window.JetSmartFilterSettings.settings[_this.filterGroup.provider][_this.filterGroup.queryId]) {\n      window.JetSmartFilterSettings.settings[_this.filterGroup.provider][_this.filterGroup.queryId]['custom_start_from'] = true;\n      window.JetSmartFilterSettings.settings[_this.filterGroup.provider][_this.filterGroup.queryId]['start_from_month'] = monthData[0];\n      window.JetSmartFilterSettings.settings[_this.filterGroup.provider][_this.filterGroup.queryId]['start_from_year'] = monthData[1];\n    }\n  });\n\n  // jetWooBuilder\n  $(document).on('jet-woo-builder-content-rendered', function () {\n    if (_this.filterGroup.provider !== 'woocommerce-archive') return;\n    _this.filterGroup.getFiltersByName('pagination').forEach(function (paginationFilter) {\n      paginationFilter.resetMoreActive();\n    });\n  });\n});\n\n\n//# sourceURL=webpack:///./js/modules/CustomProvider.js?")}),"./js/modules/Indexer.js":
/*!*******************************!*\
  !*** ./js/modules/Indexer.js ***!
  \*******************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ Indexer)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\n\nvar Indexer = /*#__PURE__*/function () {\n  function Indexer(filter) {\n    var _this = this;\n    _classCallCheck(this, Indexer);\n    _defineProperty(this, \"rowSelector\", '.jet-filter-row');\n    _defineProperty(this, \"counterSelector\", '.jet-filters-counter');\n    this.filter = filter;\n    this.currentIndexerData = this.indexerData;\n    this.isCounter = this.filter.$container.data('showCounter') === 'yes' ? true : false;\n    this.indexerRule = this.filter.$container.data('indexerRule');\n    this.changeCounte = this.filter.$container.data('changeCounter');\n    if (!this.isCounter && this.indexerRule === 'show') return;\n    this.set();\n\n    // flag which displays updated only the current filter or not\n    // needed to implement the option \"Change Counters -> Other Filters Changed\"\n    var onlyCurrentFilterChanged = true;\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('fiter/apply', function (filter) {\n      if (filter.filterId != _this.filter.filterId) onlyCurrentFilterChanged = false;\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('ajaxFilters/updated', function (provider, queryId) {\n      if (!_this.filter.isCurrentProvider({\n        provider: provider,\n        queryId: queryId\n      })) return;\n      if ('never' === _this.changeCounte // no update if 'Change Counters' = 'never'\n      || 'other_changed' === _this.changeCounte && onlyCurrentFilterChanged) return;\n\n      // reset flag\n      onlyCurrentFilterChanged = true;\n      _this.update();\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('fiters/remove', function (removeFilter) {\n      if (!_this.filter.isCurrentProvider(removeFilter)) return;\n\n      // set flag\n      onlyCurrentFilterChanged = false;\n    });\n    includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('hierarchyFilters/levelsUpdated', function (filterId) {\n      if (_this.filter.filterId !== filterId) return;\n      _this.set();\n    });\n  }\n  _createClass(Indexer, [{\n    key: \"set\",\n    value: function set() {\n      var _this2 = this;\n      var $items = this.$items;\n      var itemsCount = $items.length,\n        hiddenItemsCount = 0;\n      $items.each(function (index) {\n        var $item = $items.eq(index);\n        var counts = _this2.currentIndexerData[$item.val()] || 0;\n        if (!$item.val()) {\n          hiddenItemsCount++;\n          return;\n        }\n        if (_this2.isCounter) {\n          switch ($item.prop('tagName')) {\n            case 'INPUT':\n              $item = $item.closest(_this2.rowSelector);\n              $item.find(_this2.counterSelector + ' .value').text(counts);\n              break;\n            case 'OPTION':\n              if ($item.attr('loading-item') !== '' && '' !== $item.attr('value')) {\n                $item.text($item.data('label') + ' ' + $item.data('counter-prefix') + counts + $item.data('counter-suffix'));\n              }\n              break;\n          }\n        } else {\n          if ($item.prop('tagName') === 'INPUT') $item = $item.closest(_this2.rowSelector);\n        }\n        if (['hide', 'disable'].includes(_this2.indexerRule)) {\n          if (counts || _this2.hasNonEmptyNestedItems($item)) {\n            $item.removeClass('jet-filter-row-' + _this2.indexerRule);\n            if ($item.prop('tagName') === 'OPTION' && _this2.indexerRule === 'hide' && $item.parent('span.jet-filter-row-hide').length) $item.unwrap();\n            if ($item.prop('tagName') === 'OPTION' && _this2.indexerRule === 'disable') $item.removeAttr('disabled');\n          } else {\n            $item.addClass('jet-filter-row-' + _this2.indexerRule);\n            if ($item.prop('tagName') === 'OPTION' && _this2.indexerRule === 'hide' && !$item.parent('span.jet-filter-row-hide').length && $item.val()) $item.wrap('<span class=\"jet-filter-row-hide\" />');\n            if ($item.prop('tagName') === 'OPTION' && _this2.indexerRule === 'disable') $item.attr('disabled', true);\n          }\n          if ('hide' === _this2.indexerRule && 0 === counts) {\n            hiddenItemsCount++;\n          }\n        }\n      });\n      if ('hide' === this.indexerRule) {\n        if (!this.filter.isHierarchy || this.filter.isHierarchy && this.filter.depth === 0) {\n          if (hiddenItemsCount >= itemsCount) {\n            this.filter.$container.hide();\n            this.filter.$applyButton.hide();\n          } else {\n            this.filter.$container.show();\n            this.filter.$applyButton.show();\n          }\n        } else {\n          if (hiddenItemsCount >= itemsCount) {\n            this.filter.$filter.hide();\n          } else {\n            this.filter.$filter.show();\n          }\n        }\n      }\n      this.updateFilter();\n    }\n  }, {\n    key: \"update\",\n    value: function update() {\n      var indexerData = this.indexerData;\n      if ((0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.isEqual)(indexerData, this.currentIndexerData)) {\n        return;\n      } else {\n        this.currentIndexerData = indexerData;\n      }\n\n      /* if ('never' === this.changeCounte)\n      \tthis.isCounter = false; */\n\n      this.set();\n    }\n  }, {\n    key: \"updateFilter\",\n    value: function updateFilter() {\n      if (this.filter.additionalFilterSettings) this.filter.additionalFilterSettings.toggleItemsVisibility();\n    }\n  }, {\n    key: \"$items\",\n    get: function get() {\n      return this.filter.$filter.find('input, option');\n    }\n  }, {\n    key: \"indexerData\",\n    get: function get() {\n      var data = (0,includes_utility__WEBPACK_IMPORTED_MODULE_1__.getNesting)(JetSmartFilterSettings, 'jetFiltersIndexedData');\n      var output = {};\n      for (var provider in data) {\n        if (provider !== this.filter.provider + '/' + this.filter.queryId) continue;\n        for (var type in data[provider]) {\n          if (type !== this.filter.queryType) continue;\n          for (var itemName in data[provider][type]) {\n            if (itemName !== this.filter.queryVar) continue;\n            for (var itemKey in data[provider][type][itemName]) output[itemKey] = data[provider][type][itemName][itemKey];\n          }\n        }\n      }\n      return output;\n    }\n\n    // Checks if the nested elements are not empty and the parent is empty, then do not hide or disable it\n  }, {\n    key: \"hasNonEmptyNestedItems\",\n    value: function hasNonEmptyNestedItems($item) {\n      var isNonEmptyNested = false;\n      if (!$item.hasClass('jet-list-tree__parent')) return isNonEmptyNested;\n      var $nestedGroup = $item.next('.jet-list-tree__children');\n      if (!$nestedGroup.length) return isNonEmptyNested;\n      var indexerData = this.currentIndexerData;\n      $nestedGroup.find('input.jet-checkboxes-list__input').each(function (index, input) {\n        if (indexerData[input.value]) {\n          isNonEmptyNested = true;\n          return false;\n        }\n      });\n      return isNonEmptyNested;\n    }\n  }]);\n  return Indexer;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/Indexer.js?")}),"./js/modules/PredefinedData.js":
/*!**************************************!*\
  !*** ./js/modules/PredefinedData.js ***!
  \**************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ PredefinedData)\n/* harmony export */ });\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\nfunction _iterableToArray(iter) { if (typeof Symbol !== \"undefined\" && iter[Symbol.iterator] != null || iter[\"@@iterator\"] != null) return Array.from(iter); }\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar PredefinedData = /*#__PURE__*/function () {\n  function PredefinedData(filterGroup) {\n    _classCallCheck(this, PredefinedData);\n    this.filterGroup = filterGroup;\n    this.setted = {};\n  }\n  _createClass(PredefinedData, [{\n    key: \"set\",\n    value: function set() {\n      var _this = this;\n      var wasSetted = false,\n        filtersWithAdditionalProviders = [];\n      this.filters.forEach(function (filter) {\n        if (_this.setted[filter.filterId]) return;\n        var filterValue = filter.data;\n        var predefinedValue = filter.$filter.attr('data-predefined-value');\n        _this.setted[filter.filterId] = predefinedValue;\n        if (filterValue == predefinedValue) return;\n\n        // Prepare new filter data from a predefined value\n        var newValue = predefinedValue;\n\n        // multiple values\n        if (['checkboxes', 'check-range', 'alphabet', 'visual'].includes(filter.name)) if (newValue.indexOf(',') > -1) newValue = newValue.split(',').map(function (item) {\n          return item.trim();\n        });\n\n        // If the filter already has data\n        if (filterValue) {\n          if (['checkboxes', 'check-range'].includes(filter.name) || filter.name === 'alphabet' && filter.$checkboxes.first().attr('type') === 'checkbox' || filter.name === 'visual' && filter.$checkboxes.first().attr('type') === 'checkbox') {\n            newValue = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.mergeData)(filterValue, newValue);\n          } else {\n            return;\n          }\n        }\n\n        // Set new data\n        if (filter.name === 'select' && filter.isHierarchy) {\n          filter.hierarchicalInstance.setData(newValue.split('-').map(function (item) {\n            return item.trim();\n          }));\n        } else {\n          filter.setData(newValue);\n          filter.wasСhanged(false);\n        }\n\n        // if filter has additional providers\n        if (Array.isArray(filter.additionalProviders)) filtersWithAdditionalProviders.push(filter);\n        wasSetted = true;\n      });\n      if (wasSetted) {\n        // update group provider\n        this.filterGroup.apply();\n\n        // updating additional providers in the next tick so that all data in groups is updated\n        setTimeout(function () {\n          var additionalProvidersNeedingUpdating = [];\n          filtersWithAdditionalProviders.forEach(function (filterWithAdditionalProviders) {\n            filterWithAdditionalProviders.additionalProviders.forEach(function (additionalProviderKey) {\n              var additionalProvide = includes_utility__WEBPACK_IMPORTED_MODULE_0__.getProvider.apply(void 0, _toConsumableArray(additionalProviderKey.split('/', 2)));\n              if (!additionalProvide) return;\n              var isAdditionalFilterUpdated = additionalProvide.additionalFilters.updateAdditionalFilterByParent(filterWithAdditionalProviders);\n              if (isAdditionalFilterUpdated && additionalProvidersNeedingUpdating.every(function (additionalProviderNeedingUpdating) {\n                return additionalProviderNeedingUpdating.providerKey !== additionalProvide.providerKey;\n              })) additionalProvidersNeedingUpdating.push(additionalProvide);\n            });\n          });\n          additionalProvidersNeedingUpdating.forEach(function (additionalProviderNeedingUpdating) {\n            additionalProviderNeedingUpdating.apply();\n          });\n        });\n      }\n    }\n  }, {\n    key: \"filters\",\n    get: function get() {\n      return this.filterGroup.filters.filter(function (filter) {\n        return filter.$filter && filter.$filter.data('predefined-value');\n      });\n    }\n  }]);\n  return PredefinedData;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/PredefinedData.js?")}),"./js/modules/ProviderPreloader.js":
/*!*****************************************!*\
  !*** ./js/modules/ProviderPreloader.js ***!
  \*****************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ ProviderPreloader)\n/* harmony export */ });\n/* harmony import */ var includes_utility__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/utility */ \"./js/includes/utility.js\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar ProviderPreloader = /*#__PURE__*/function () {\n  function ProviderPreloader(filterGroup) {\n    _classCallCheck(this, ProviderPreloader);\n    this.filterGroup = filterGroup;\n    this.containerLoadingClass = 'jet-filters-loading';\n    this.preloaderClass = 'jsf_provider-preloader';\n    this.preloaderTemplate = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'provider_preloader', 'template');\n    this.fixedPosition = (0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'provider_preloader', 'fixed_position');\n    this.fixedEdgeGap = parseInt((0,includes_utility__WEBPACK_IMPORTED_MODULE_0__.getNesting)(JetSmartFilterSettings, 'plugin_settings', 'provider_preloader', 'fixed_edge_gap')) || 0;\n    this.$container = null;\n    this.$preloader = null;\n  }\n  _createClass(ProviderPreloader, [{\n    key: \"show\",\n    value: function show() {\n      this.filterGroup.$provider.addClass(this.containerLoadingClass);\n      if (!this.preloaderTemplate) return;\n      if (this.filterGroup.provider === 'bricks-query-loop') {\n        this.$container = this.filterGroup.$provider.first().append(this.preloaderTemplate);\n        this.$preloader = this.filterGroup.$provider.first().find(\">.\".concat(this.preloaderClass));\n      } else {\n        this.$container = this.filterGroup.$provider.append(this.preloaderTemplate);\n        this.$preloader = this.filterGroup.$provider.find(\">.\".concat(this.preloaderClass));\n      }\n      if (!this.fixedPosition) return;\n      this.handleEvent();\n      window.addEventListener('scroll', this);\n      window.addEventListener('resize', this);\n    }\n  }, {\n    key: \"hide\",\n    value: function hide() {\n      this.filterGroup.$provider.removeClass(this.containerLoadingClass);\n      if (this.$preloader && this.$preloader.remove) this.$preloader.remove();\n      this.$preloader = null;\n      this.$container = null;\n      window.removeEventListener('scroll', this);\n      window.removeEventListener('resize', this);\n    }\n  }, {\n    key: \"handleEvent\",\n    value: function handleEvent() {\n      var containerRect = this.$container.get(0).getBoundingClientRect(),\n        containerTop = containerRect.top,\n        containerLeft = containerRect.left,\n        containerHeight = containerRect.height,\n        containerWidth = containerRect.width,\n        preloaderHeight = this.$preloader.outerHeight(),\n        centerPosition = window.innerHeight / 2 - preloaderHeight / 2,\n        topPosition = centerPosition - containerTop - this.fixedEdgeGap,\n        bottomPosition = containerHeight + containerTop - preloaderHeight - centerPosition - this.fixedEdgeGap,\n        isFixed = topPosition > 0 && bottomPosition > 0 ? true : false;\n      if (isFixed) {\n        this.$preloader.css({\n          position: 'fixed',\n          top: \"\".concat(centerPosition, \"px\"),\n          left: \"\".concat(containerLeft + containerWidth / 2, \"px\")\n        });\n      } else {\n        this.$preloader.css({\n          position: 'absolute',\n          top: containerTop >= 0 ? \"\".concat(this.fixedEdgeGap, \"px\") : \"\".concat(containerHeight - preloaderHeight - this.fixedEdgeGap, \"px\"),\n          left: '50%'\n        });\n      }\n    }\n  }]);\n  return ProviderPreloader;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/ProviderPreloader.js?")}),"./js/modules/TabIndex.js":
/*!********************************!*\
  !*** ./js/modules/TabIndex.js ***!
  \********************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ TabIndex)\n/* harmony export */ });\n/* harmony import */ var includes_event_bus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! includes/event-bus */ \"./js/includes/event-bus.js\");\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\n\nvar TabIndex = /*#__PURE__*/function () {\n  function TabIndex(filter) {\n    _classCallCheck(this, TabIndex);\n    if (!filter.$filter) return;\n    this.filter = filter;\n    switch (this.filter.name) {\n      case 'checkboxes':\n      case 'radio':\n      case 'check-range':\n      case 'alphabet':\n      case 'visual':\n        this.checkboxes();\n        if (this.filter.additionalFilterSettings && this.filter.additionalFilterSettings.$dropdown.length) this.checkboxesDropdown();\n        break;\n      case 'rating':\n        this.rating();\n        break;\n      case 'range':\n        this.range();\n        break;\n      case 'date-period':\n        this.datePeriod();\n        break;\n      case 'pagination':\n        this.pagination();\n        break;\n      case 'active-filters':\n      case 'active-tags':\n        this.activeItems();\n        break;\n    }\n\n    // Indexer addition\n    this.indexerAddition();\n  }\n\n  // Methods\n  _createClass(TabIndex, [{\n    key: \"itemsTriggerClickOnEnterPress\",\n    value: function itemsTriggerClickOnEnterPress($items) {\n      $items.keypress(function (e) {\n        e.preventDefault();\n        if (e.keyCode === 13) $(e.target).trigger('click');\n      });\n    }\n\n    /* \n     * TabIndex types\n     */\n  }, {\n    key: \"checkboxes\",\n    value: function checkboxes() {\n      var _this = this;\n      this.filter.$filter.find('label[tabindex]').keypress(function (e) {\n        e.preventDefault();\n        if (![13, 32].includes(e.keyCode)) return;\n        var $itemInput = $(e.target).find('input');\n        $itemInput.prop('checked', !$itemInput.prop('checked'));\n        _this.filter.processData();\n        _this.filter.emitFiterApply();\n      });\n      this.filter.$filter.find('.jet-filter-items-moreless[tabindex]').keypress(function (e) {\n        e.preventDefault();\n        if (![13, 32].includes(e.keyCode)) return;\n        _this.filter.additionalFilterSettings.moreLessToggle();\n      });\n    }\n  }, {\n    key: \"checkboxesDropdown\",\n    value: function checkboxesDropdown() {\n      var _this2 = this;\n      this.filter.additionalFilterSettings.$dropdown.find('.jet-filter-items-dropdown__label').keypress(function (e) {\n        e.preventDefault();\n        if (![13, 32].includes(e.keyCode)) return;\n        _this2.filter.additionalFilterSettings.dropdownToggle();\n      });\n      this.filter.$filter.find('[tabindex]').last().keydown(function (e) {\n        if (e.keyCode === 9) _this2.filter.additionalFilterSettings.dropdownClose();\n      });\n    }\n  }, {\n    key: \"rating\",\n    value: function rating() {\n      this.filter.$filter.find('[tabindex]').keypress(function (e) {\n        e.preventDefault();\n        $(e.target).prev('input').trigger('click');\n      });\n    }\n  }, {\n    key: \"range\",\n    value: function range() {\n      var _this3 = this;\n      this.filter.$filter.find('[tabindex]').keydown(function (e) {\n        if (![13, 32, 37, 38, 39, 40].includes(e.keyCode)) return;\n        e.preventDefault();\n        var $input = $(e.target);\n\n        // arrow keys processing\n        if ([37, 38, 39, 40].includes(e.keyCode)) {\n          // decrease\n          if ([37, 40].includes(e.keyCode)) $input.val(parseFloat($input.val()) - parseFloat($input.attr('step')));\n\n          //increase\n          if ([38, 39].includes(e.keyCode)) $input.val(parseFloat($input.val()) + parseFloat($input.attr('step')));\n          $input.trigger('input');\n          _this3.filter.processData();\n        }\n        if (e.keyCode === 13) _this3.filter.emitFiterApply();\n      });\n    }\n  }, {\n    key: \"datePeriod\",\n    value: function datePeriod() {\n      var _this4 = this;\n      if (!this.filter.$datepickerBtn.is('[tabindex]')) return;\n      this.filter.$datepickerBtn.focus(function () {\n        _this4.filter.datepicker.show();\n      });\n      this.filter.$datepickerBtn.blur(function () {\n        if (!_this4.filter.datepicker.inFocus) _this4.filter.datepicker.hide();\n      });\n      this.filter.$datepickerBtn.on('keydown.adp', this.filter.datepicker._onKeyDown.bind(this.filter.datepicker));\n      this.filter.$datepickerBtn.on('keyup.adp', this.filter.datepicker._onKeyUp.bind(this.filter.datepicker));\n      this.filter.$datepickerBtn.keypress(function (e) {\n        if ([32].includes(e.keyCode)) {\n          if (!_this4.filter.datepicker.visible) {\n            _this4.filter.datepicker.show();\n          } else {\n            _this4.filter.datepicker.hide();\n          }\n        }\n      });\n      this.filter.$prevPeriodBtn.keypress(function (e) {\n        if (![13, 32, 37, 39].includes(e.keyCode)) return;\n        e.preventDefault();\n        if (e.keyCode === 13) _this4.filter.prevPeriod();\n      });\n      this.filter.$nextPeriodBtn.keypress(function (e) {\n        if (![13, 32, 37, 39].includes(e.keyCode)) return;\n        e.preventDefault();\n        if (e.keyCode === 13) _this4.filter.nextPeriod();\n      });\n    }\n  }, {\n    key: \"pagination\",\n    value: function pagination() {\n      var _this5 = this;\n      this.itemsTriggerClickOnEnterPress(this.filter.$filter.find('[tabindex]'));\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('pagination/itemsBuilt', function (filter) {\n        _this5.itemsTriggerClickOnEnterPress(filter.$filter.find('[tabindex]'));\n      });\n    }\n  }, {\n    key: \"activeItems\",\n    value: function activeItems() {\n      var _this6 = this;\n      this.itemsTriggerClickOnEnterPress(this.filter.$activeItemsContainer.find('[tabindex]'));\n      includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('activeItems/itemsBuilt', function (filter) {\n        _this6.itemsTriggerClickOnEnterPress(filter.$activeItemsContainer.find('[tabindex]'));\n      });\n    }\n  }, {\n    key: \"indexerAddition\",\n    value: function indexerAddition() {\n      var _this7 = this;\n      if (!this.filter.indexer) return;\n\n      // disable tabindex if item disabled by indexer\n      if (this.filter.indexer.indexerRule === 'disable') {\n        var disableTabindex = function disableTabindex() {\n          _this7.filter.$filter.find('.jet-filter-row [tabindex=\"-1\"]').attr('tabindex', '0');\n          _this7.filter.$filter.find('.jet-filter-row-disable [tabindex=\"0\"]').attr('tabindex', '-1');\n        };\n        disableTabindex();\n        includes_event_bus__WEBPACK_IMPORTED_MODULE_0__[\"default\"].subscribe('ajaxFilters/updated', function (provider, queryId) {\n          if (!_this7.filter.isCurrentProvider({\n            provider: provider,\n            queryId: queryId\n          })) return;\n          disableTabindex();\n        });\n      }\n    }\n  }]);\n  return TabIndex;\n}();\n\n\n//# sourceURL=webpack:///./js/modules/TabIndex.js?")}),"./js/modules/СollapsibleList.js":
/*!***************************************!*\
  !*** ./js/modules/СollapsibleList.js ***!
  \***************************************/
((__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ СollapsibleList)\n/* harmony export */ });\n/* provided dependency */ var $ = __webpack_require__(/*! jquery */ \"jquery\");\nfunction _typeof(obj) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && \"function\" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }, _typeof(obj); }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nvar СollapsibleList = /*#__PURE__*/_createClass(function СollapsibleList(filter) {\n  var _this = this;\n  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n  _classCallCheck(this, СollapsibleList);\n  this.collapsibleLists = [];\n  this.settings = Object.assign({\n    // defaults options\n    collapsed: true,\n    collapseSpeed: 300,\n    animate: true,\n    collapsibleElementClass: 'jet-list-collapsible',\n    toggleElementClass: 'jet-list-tree__parent',\n    contentElementClass: 'jet-list-tree__children',\n    toggleCollapsedClass: 'jet-list-toggle-collapsed',\n    contentCollapsedClass: 'jet-list-content-collapsed',\n    excludedClickelEmentsSelector: 'label'\n  }, options);\n\n  // Init\n  filter.$container.find('.' + this.settings.collapsibleElementClass + ' .' + this.settings.toggleElementClass).each(function (index, element) {\n    var $toggle = $(element);\n    var $content = $toggle.next();\n    if (!$content.hasClass(_this.settings.contentElementClass)) return;\n    _this.collapsibleLists.push({\n      $toggle: $toggle,\n      $content: $content\n    });\n    var isContainChecked = $content.find('input:checked').length ? true : false;\n    if (_this.settings.collapsed && !isContainChecked) {\n      $toggle.addClass(_this.settings.toggleCollapsedClass);\n      $content.addClass(_this.settings.contentCollapsedClass).slideUp(0);\n    } else {\n      $toggle.removeClass(_this.settings.toggleCollapsedClass);\n      $content.removeClass(_this.settings.contentCollapsedClass).slideDown(0);\n    }\n    $toggle.click(function (evt) {\n      $toggle.toggleClass(_this.settings.toggleCollapsedClass);\n      $content.toggleClass(_this.settings.contentCollapsedClass).slideToggle(_this.settings.collapseSpeed);\n    });\n    $toggle.find(_this.settings.excludedClickelEmentsSelector).click(function (evt) {\n      evt.stopPropagation();\n    });\n  });\n});\n\n\n//# sourceURL=webpack:///./js/modules/%D0%A1ollapsibleList.js?")}),"jquery":
/*!*************************!*\
  !*** external "jQuery" ***!
  \*************************/
((module)=>{"use strict";module.exports=jQuery})});var __webpack_module_cache__={};function __webpack_require__(moduleId){var cachedModule=__webpack_module_cache__[moduleId];if(cachedModule!==undefined){return cachedModule.exports}var module=__webpack_module_cache__[moduleId]={exports:{}};__webpack_modules__[moduleId](module,module.exports,__webpack_require__);return module.exports}(()=>{__webpack_require__.n=(module)=>{var getter=module&&module.__esModule?()=>(module['default']):()=>(module);__webpack_require__.d(getter,{a:getter});return getter}})();(()=>{__webpack_require__.d=(exports,definition)=>{for(var key in definition){if(__webpack_require__.o(definition,key)&&!__webpack_require__.o(exports,key)){Object.defineProperty(exports,key,{enumerable:!0,get:definition[key]})}}}})();(()=>{__webpack_require__.o=(obj,prop)=>(Object.prototype.hasOwnProperty.call(obj,prop))})();(()=>{__webpack_require__.r=(exports)=>{if(typeof Symbol!=='undefined'&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:'Module'})}Object.defineProperty(exports,'__esModule',{value:!0})}})();var __webpack_exports__=__webpack_require__("./js/index.js")})()